/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.unreal.server;

import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public abstract class UnrealServerDefinition<T extends IUnrealServer>
extends ServerDefinition<T> {
    private static final long serialVersionUID = -2167034240278963009L;
    transient ICommandListener<ChangeMap> mapChangeListener = null;
    protected transient T server = null;

    @Override
    public void startServer() throws PogamutException {
        if (this.server != null && !((IAgentState)this.server.getState().getFlag()).isState(new Class[]{IAgentStateStopped.class, IAgentStateFailed.class})) {
            this.server.stop();
        }
        this.server = this.createServer();
        this.server.getState().addListener((FlagListener)new FlagListener<IAgentState>(){

            public void flagChanged(IAgentState state) {
                if (state.isState(new Class[]{IAgentStateStopped.class, IAgentStateFailed.class})) {
                    UnrealServerDefinition.this.setNewServer(null);
                }
            }
        });
        this.setNewServer(this.server);
    }

    protected abstract T createServer();

    protected void serverStopped(T server) {
    }

    @Override
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            this.setNewServer(null);
        }
    }
}

