/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.component.ComponentStub;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestCompositeViewableObject;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestCompositeViewableObjectMessage;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.stubs.MediatorStub;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.stubs.UT2004TestLocalWorldView;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.stubs.UT2004TestSharedWorldView;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.StopWatch;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class Test01_UT2004VisionLocalWorldView_simpleTest
extends BaseTest {
    private static final long GLOBAL_TIMEOUT_IN_MINUTES = 10L;
    public static FileHandler fh;
    public static Logger global;
    public static List<IAgentLogger> agentLogs;
    public static ISharedWorldView sharedWV;
    static boolean failure;
    static CountDownLatch latch;
    static CountDownLatch latch2;

    public static void setLogLevel(Level level) {
        global.setLevel(level);
        for (IAgentLogger log : agentLogs) {
            log.setLevel(level);
        }
    }

    public static void initSWV() {
        try {
            fh = new FileHandler("./log01");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleFormatter f = new SimpleFormatter();
        fh.setFormatter(f);
        agentLogs = new LinkedList<IAgentLogger>();
        global = Logger.getLogger("Global");
        global.setLevel(Level.FINER);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINER);
        global.addHandler(consoleHandler);
        global.addHandler(fh);
        sharedWV = new UT2004TestSharedWorldView(global);
    }

    @Test
    public void simpleTest() {
        Test01_UT2004VisionLocalWorldView_simpleTest.initSWV();
        int events = 250;
        int runs = 150;
        long sleepTime = 40L;
        long runnerSleepTime = 20L;
        Handler hndlr = new Handler();
        LinkedList<LogicRunner> thrds = new LinkedList<LogicRunner>();
        int agents = 1;
        latch = new CountDownLatch(agents + 1);
        TeamId tId = new TeamId("RED");
        EventGeneratorHandler eventHandler = new EventGeneratorHandler(events, 0L, sleepTime, hndlr);
        StopWatch watch = new StopWatch();
        for (int i = 0; i < agents; ++i) {
            TeamedAgentId teamedAgentId = new TeamedAgentId("Agent[" + i + "]");
            teamedAgentId.setTeamId(tId);
            LogicRunner r = new LogicRunner(teamedAgentId, runs, events, runnerSleepTime, hndlr);
            eventHandler.addWorldView(r.wv);
            thrds.add(r);
            r.startWV();
        }
        Test01_UT2004VisionLocalWorldView_simpleTest.setLogLevel(Level.INFO);
        for (Thread thread2 : thrds) {
            thread2.start();
        }
        eventHandler.start();
        try {
            latch.await(10L, TimeUnit.MINUTES);
            if (latch.getCount() > 0L || failure) {
                failure = true;
                throw new RuntimeException("FAILURE!!!");
            }
        }
        catch (InterruptedException e) {
            failure = true;
            throw new RuntimeException(e);
        }
        System.out.println("Test took: " + watch.stopStr());
        thrds = null;
        eventHandler = null;
        sharedWV = null;
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void multipleAgentsTest() {
        Test01_UT2004VisionLocalWorldView_simpleTest.initSWV();
        int events = 150;
        int runs = 150;
        long sleepTime = 40L;
        long runnerSleepTime = 20L;
        Handler hndlr = new Handler();
        LinkedList<LogicRunner> thrds = new LinkedList<LogicRunner>();
        int agents = 4;
        latch = new CountDownLatch(agents + 1);
        TeamId tId = new TeamId("RED");
        EventGeneratorHandler eventHandler = new EventGeneratorHandler(events, 0L, sleepTime, hndlr);
        StopWatch watch = new StopWatch();
        for (int i = 0; i < agents; ++i) {
            TeamedAgentId teamedAgentId = new TeamedAgentId("Agent[" + i + "]");
            teamedAgentId.setTeamId(tId);
            LogicRunner r = new LogicRunner(teamedAgentId, runs, events, runnerSleepTime, hndlr);
            eventHandler.addWorldView(r.wv);
            thrds.add(r);
            r.startWV();
        }
        Test01_UT2004VisionLocalWorldView_simpleTest.setLogLevel(Level.INFO);
        for (Thread thread2 : thrds) {
            thread2.start();
        }
        eventHandler.start();
        try {
            latch.await(10L, TimeUnit.MINUTES);
            if (latch.getCount() > 0L || failure) {
                failure = true;
                throw new RuntimeException("FAILURE!!!");
            }
        }
        catch (InterruptedException e) {
            failure = true;
            throw new RuntimeException(e);
        }
        System.out.println("Test took: " + watch.stopStr());
        thrds = null;
        eventHandler = null;
        sharedWV = null;
        System.out.println("---/// TEST OK ///---");
    }

    public static void totalCountDown2() {
        while (latch2.getCount() > 0L) {
            latch2.countDown();
        }
    }

    public static void totalCountDown() {
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    static {
        failure = false;
    }

    public static class EventGeneratorHandler
    extends Thread {
        Map<TeamedAgentId, ILocalWorldView> localWorldViews;
        int eventsPerCycle;
        long currentTime;
        Handler handler;
        long sleepTime;

        public EventGeneratorHandler(int eventsPerCycle, long initTime, long sleepTime, Handler handlerInstance) {
            this.eventsPerCycle = eventsPerCycle;
            this.currentTime = initTime;
            this.handler = handlerInstance;
            this.sleepTime = sleepTime;
            this.localWorldViews = new HashMap<TeamedAgentId, ILocalWorldView>();
        }

        public void addWorldView(ILocalWorldView wv) {
            this.localWorldViews.put((TeamedAgentId)wv.getAgentId(), wv);
        }

        @Override
        public void run() {
            try {
                while (!this.handler.allFinished()) {
                    if (failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    LinkedList<EventGenerator> thrds = new LinkedList<EventGenerator>();
                    for (TeamedAgentId teamedAgentId : this.localWorldViews.keySet()) {
                        if (this.handler.cyclesToRun(teamedAgentId) < 0) continue;
                        thrds.add(new EventGenerator(this.eventsPerCycle, this.currentTime, this.localWorldViews.get(teamedAgentId)));
                    }
                    latch2 = new CountDownLatch(thrds.size());
                    for (Thread thread2 : thrds) {
                        thread2.start();
                    }
                    latch2.await(10L, TimeUnit.MINUTES);
                    if (latch2.getCount() > 0L || failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    ++this.currentTime;
                    EventGeneratorHandler.sleep(this.sleepTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test01_UT2004VisionLocalWorldView_simpleTest.totalCountDown();
                return;
            }
            latch.countDown();
        }
    }

    public static class LogicRunner
    extends Thread {
        protected BatchAwareLocalWorldView wv;
        protected ITeamedAgentId id;
        int runs;
        int objects;
        long sleepTime;
        Handler handler;
        ComponentStub starter;

        public LogicRunner(ITeamedAgentId id, int runs, int objects, long sleepTime, Handler handler) {
            AgentLogger log = new AgentLogger(id);
            agentLogs.add(log);
            log.setLevel(Level.ALL);
            log.addDefaultConsoleHandler();
            log.addDefaultHandler(fh);
            LifecycleBus bus = new LifecycleBus(log);
            MediatorStub m = new MediatorStub(log);
            this.starter = new ComponentStub(log, bus);
            try {
                this.wv = new UT2004TestLocalWorldView(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(this.starter), m, bus, log, sharedWV, id);
            }
            catch (Exception e) {
                failure = true;
                e.printStackTrace();
            }
            this.id = id;
            this.runs = runs;
            this.objects = objects;
            this.sleepTime = sleepTime;
            this.handler = handler;
            handler.addNew(id, runs);
        }

        public void startWV() {
            this.starter.getController().manualStart("Test");
        }

        public void setSleepTime(long newSleepTime) {
            this.sleepTime = newSleepTime;
        }

        @Override
        public void run() {
            try {
                System.out.println(this.id + " : Logic Runner run()");
                for (int r = 0; r <= this.runs; ++r) {
                    if (failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    this.wv.lock();
                    System.out.println(this.id + "Runner run [" + r + "] remaining : time " + this.wv.getCurrentTimeKey().getTime() + ", remaining runs " + this.handler.cyclesToRun(this.id));
                    for (int i = 0; i < this.objects; ++i) {
                        long t = this.wv.getCurrentTimeKey().getTime();
                        TestCompositeViewableObject obj = (TestCompositeViewableObject)this.wv.get(WorldObjectId.get("TestObject[" + i + "]"));
                        if (obj == null) {
                            global.severe(this.id + " : NULL");
                            throw new RuntimeException("Object is null.");
                        }
                        if (obj.getLocalLong() != (long)i + t) {
                            global.severe(obj.getId() + " : " + obj.getLocalString());
                            global.severe("LocalLong fail on  object " + i + " in run " + r + " ; on WV time " + t);
                            this.handler.setEnd(this.id);
                            throw new RuntimeException("LocalLong fail on  object " + i + " in run " + r + " ; on WV time " + t);
                        }
                        if (!obj.getLocalString().equals("LS:" + this.id.toString() + "[" + i + "]" + "(" + t + ")")) {
                            throw new RuntimeException("LocalString fail");
                        }
                        if (obj.getSharedLong() != (long)(i + 1000) + t) {
                            global.severe(this.id + " : " + obj.getSharedLong() + " instead of " + ((long)(i + 1000) + t));
                            throw new RuntimeException("SharedLong fail");
                        }
                        if (!obj.getSharedString().equals("ShS:" + this.id.getTeamId().toString() + "[" + i + "]" + "(" + t + ")")) {
                            throw new RuntimeException("SharedString fail : " + obj.getSharedString());
                        }
                        if (obj.getStaticLong() != (long)i) {
                            throw new RuntimeException("StaticLong fail");
                        }
                        if (obj.getStaticString().equals("StaticString[" + i + "]")) continue;
                        throw new RuntimeException("StaticString fail");
                    }
                    LogicRunner.sleep(this.sleepTime);
                    this.wv.unlock();
                    this.handler.decrease(this.id);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test01_UT2004VisionLocalWorldView_simpleTest.totalCountDown();
                return;
            }
            latch.countDown();
        }
    }

    public static class EventGenerator
    extends Thread {
        int events;
        long time;
        ILocalWorldView localWV;
        TeamedAgentId agentId;

        public EventGenerator(int events, long time2, ILocalWorldView localWV) {
            this.events = events;
            this.time = time2;
            this.localWV = localWV;
            this.agentId = (TeamedAgentId)localWV.getAgentId();
        }

        protected void generateEvents() {
            System.out.println(this.agentId + " : generating Events [Time:" + this.time + "]");
            this.localWV.notify(new BeginMessage(this.time));
            for (int i = 0; i < this.events; ++i) {
                WorldObjectId id = WorldObjectId.get("TestObject[" + i + "]");
                TestCompositeViewableObjectMessage obj = new TestCompositeViewableObjectMessage(id, this.time, "LS:" + this.agentId.toString() + "[" + i + "]" + "(" + this.time + ")", (long)i + this.time, "ShS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + this.time + ")", (long)(i + 1000) + this.time, "StaticString[" + i + "]", Long.valueOf(i), true);
                this.localWV.notify(obj.createUpdateEvent(this.time, this.agentId.getTeamId()));
            }
            this.localWV.notify(new EndMessage(this.time));
            System.out.println(this.agentId + ": generating end");
        }

        @Override
        public void run() {
            try {
                this.generateEvents();
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test01_UT2004VisionLocalWorldView_simpleTest.totalCountDown2();
                return;
            }
            latch2.countDown();
        }
    }

    public static class Handler {
        Map<IAgentId, Integer> cycles = new HashMap<IAgentId, Integer>();

        public void addNew(IAgentId id, int cycles) {
            this.cycles.put(id, cycles);
        }

        public boolean allFinished() {
            for (Integer i : this.cycles.values()) {
                if (i < 0) continue;
                return false;
            }
            return true;
        }

        public synchronized void setEnd(IAgentId id) {
            this.cycles.put(id, -1);
        }

        public synchronized void decrease(IAgentId id) {
            int n = this.cycles.get(id);
            this.cycles.put(id, --n);
        }

        public int cyclesToRun(IAgentId id) {
            return this.cycles.get(id);
        }
    }
}

