/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.object;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class WorldObjectFuture<T extends IWorldObject>
implements Future<T> {
    private final IWorldView worldView;
    private final Class<T> objectClass;
    private T worldObject = null;
    private BusAwareCountDownLatch latch;
    private IWorldObjectListener<T> listener = null;
    private boolean cancelled = false;

    public WorldObjectFuture(final IWorldView worldView, final Class<T> objectClass) {
        this.worldView = worldView;
        this.objectClass = objectClass;
        Map<WorldObjectId, T> objects = worldView.getAll(objectClass);
        block0 : switch (objects.size()) {
            case 0: {
                this.latch = new BusAwareCountDownLatch(1, worldView.getEventBus(), worldView);
                this.listener = new IWorldObjectListener<T>(){

                    @Override
                    public void notify(IWorldObjectEvent<T> event) {
                        if (event instanceof WorldObjectDestroyedEvent) {
                            return;
                        }
                        WorldObjectFuture.this.worldObject = event.getObject();
                        worldView.removeObjectListener(objectClass, IWorldObjectEvent.class, this);
                        WorldObjectFuture.this.customObjectEncounteredHook(WorldObjectFuture.this.worldObject);
                        WorldObjectFuture.this.latch.countDown();
                    }
                };
                worldView.addObjectListener(objectClass, IWorldObjectEvent.class, this.listener);
                objects = worldView.getAll(objectClass);
                switch (objects.size()) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        worldView.removeObjectListener(objectClass, IWorldObjectEvent.class, this.listener);
                        this.worldObject = (IWorldObject)objects.values().iterator().next();
                        this.latch.countDown();
                        break block0;
                    }
                    case 2: {
                        if (this.worldObject != null) {
                            return;
                        }
                        worldView.removeObjectListener(objectClass, IWorldObjectEvent.class, this.listener);
                        this.latch.countDown();
                        throw new WorldObjectFutureException("There are already " + objects.size() + " objects in world view of class " + objectClass.getSimpleName() + ".", (Object)this);
                    }
                }
                break;
            }
            case 1: {
                this.latch = new BusAwareCountDownLatch(0, worldView.getEventBus(), worldView);
                this.worldObject = (IWorldObject)objects.values().iterator().next();
                this.customObjectEncounteredHook(this.worldObject);
                break;
            }
            default: {
                throw new WorldObjectFutureException("There are already " + objects.size() + " objects in world view of class " + objectClass.getSimpleName() + ".", (Object)this);
            }
        }
    }

    public WorldObjectFuture(final IWorldView worldView, final String id, final Class<T> objectClass) {
        this.worldView = worldView;
        this.objectClass = objectClass;
        IWorldObject o = worldView.get(WorldObjectId.get(id));
        if (o != null) {
            this.worldObject = o;
            this.latch = new BusAwareCountDownLatch(0, worldView.getEventBus(), worldView);
        } else {
            this.latch = new BusAwareCountDownLatch(1, worldView.getEventBus(), worldView);
            this.listener = new IWorldObjectListener<T>(){

                @Override
                public void notify(IWorldObjectEvent<T> event) {
                    if (event instanceof WorldObjectDestroyedEvent) {
                        return;
                    }
                    if (event.getObject().getId().getStringId().equals(id)) {
                        WorldObjectFuture.this.worldObject = event.getObject();
                        worldView.removeObjectListener(objectClass, IWorldObjectEvent.class, this);
                        WorldObjectFuture.this.latch.countDown();
                        WorldObjectFuture.this.customObjectEncounteredHook(WorldObjectFuture.this.worldObject);
                    }
                }
            };
            worldView.addObjectListener(objectClass, IWorldObjectEvent.class, this.listener);
            o = worldView.get(WorldObjectId.get(id));
            if (o != null) {
                worldView.removeObjectListener(objectClass, WorldObjectFirstEncounteredEvent.class, this.listener);
                this.latch.countDown();
            }
        }
    }

    protected void customObjectEncounteredHook(T obj) {
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.latch != null) {
            this.latch.countDown();
        }
        this.cancelled = true;
        this.worldView.removeObjectListener(this.objectClass, IWorldObjectEvent.class, this.listener);
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.worldObject != null;
    }

    @Override
    public T get() {
        this.latch.await();
        return this.worldObject;
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        this.latch.await(timeout, unit);
        return this.worldObject;
    }

    public static class WorldObjectFutureException
    extends PogamutException {
        public WorldObjectFutureException(String message, Object origin) {
            super(message, origin);
        }
    }
}

