 package nl.tudelft.goal.ut2004.translators;

import java.util.Arrays;
import java.util.Set;

import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Group;
import eis.eis2java.exception.TranslationException;
import eis.eis2java.translation.Java2Parameter;
import eis.eis2java.translation.Parameter2Java;
import eis.eis2java.translation.Translator;
import eis.iilang.Identifier;
import eis.iilang.Parameter;

public class ItemTypeTranslator implements Java2Parameter<ItemType>, Parameter2Java<ItemType> {

	@Override
	public Parameter[] translate(ItemType o) throws TranslationException {
		return new Parameter[] { new Identifier(o.getGroup().name().toLowerCase()) };
	}

	@Override
	public Class<? extends ItemType> translatesFrom() {
		return ItemType.class;
	}

	@Override
	public ItemType translate(Parameter parameter) throws TranslationException {
		String itemTypeString = Translator.getInstance().translate2Java(parameter, String.class);

		try {
			Group itemGroup = Group.valueOf(itemTypeString.toUpperCase());
			Set<ItemType> items = ItemType.GROUPS.get(itemGroup );
			for(ItemType item : items){
				if(item.getCategory() == Category.WEAPON){
					return item;
				}
			}
			
			String message = String.format("%s was not a ItemType in the weapon category.", itemTypeString);
			throw new TranslationException(message);
		} catch (IllegalArgumentException e) {
			String message = String.format("%s was not a ItemType. Expected on off %s.", itemTypeString, Arrays.toString(Group.values()));
			throw new TranslationException(message, e);
		}
	}

	@Override
	public Class<ItemType> translatesTo() {
		return ItemType.class;
	}

}
