package nl.tudelft.goal.ut2004.selector;

import java.util.Collection;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.utils.NullCheck;

/**
 * Select the player with the given unreal ID.
 * 
 * @author mpkorstanje
 * 
 */
public class APlayer extends ContextSelector {

	protected final UnrealId id;

	public APlayer(UnrealId id) {
		NullCheck.check(id, "id");
		this.id = id;
	}

	@Override
	public ILocated select(Collection<? extends ILocated> c) {
		// Optimization: Selecting from map is faster then selecting from the
		// collection.
		return modules.getPlayers().getVisiblePlayers().get(id);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "APlayer [id=" + id + "]";
	}
}
