/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SyncHashMap<K, V> {
    private Map<K, V> map = new HashMap();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock(false);
    private Lock readLock = this.rwLock.readLock();
    private Lock writeLock = this.rwLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            V v = this.map.put(key, value);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        this.writeLock.lock();
        try {
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        this.readLock.lock();
        try {
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int size() {
        return this.map.size();
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }
}

