/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004PositionStuckDetector
implements IStuckDetector {
    private static double DEFAULT_MIN_DIAMETER = 60.0;
    private static double DEFAULT_MIN_Z = 80.0;
    private static int DEFAULT_HISTORY_LENGTH = 8;
    private UT2004Bot bot;
    private double minMovementDiameter;
    private int historyLength;
    private List<Location> locationHistory;
    private boolean stuck = false;
    private boolean botWaiting = false;
    private boolean enabled = false;
    private SelfListener selfListener;
    private Logger log;
    private double minMovementZ;

    public UT2004PositionStuckDetector(UT2004Bot bot) {
        this(bot, DEFAULT_HISTORY_LENGTH, DEFAULT_MIN_DIAMETER, DEFAULT_MIN_Z);
    }

    public UT2004PositionStuckDetector(UT2004Bot bot, int historyLength, double minMovementDiameter, double minMovementZ) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.selfListener = new SelfListener(bot.getWorldView());
        this.historyLength = historyLength;
        if (this.historyLength < 0) {
            throw new IllegalArgumentException("historyLength can't be < 0");
        }
        this.minMovementDiameter = minMovementDiameter;
        this.minMovementZ = minMovementZ;
        this.locationHistory = new ArrayList<Location>(this.historyLength);
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.enabled == state) {
            return;
        }
        this.enabled = state;
    }

    @Override
    public void setBotWaiting(boolean state) {
        this.botWaiting = state;
    }

    @Override
    public void setBotTarget(ILocated target) {
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        if (!this.enabled) {
            return;
        }
        if (this.botWaiting) {
            return;
        }
        this.locationHistory.add(event.getObject().getLocation());
        while (this.locationHistory.size() > this.historyLength) {
            this.locationHistory.remove(0);
        }
        if (this.locationHistory.size() == this.historyLength) {
            double maxDistance = Double.NEGATIVE_INFINITY;
            double maxHeight = Double.NEGATIVE_INFINITY;
            for (Location loc1 : this.locationHistory) {
                for (Location loc2 : this.locationHistory) {
                    if (maxDistance < loc1.getDistance2D(loc2)) {
                        maxDistance = loc1.getDistance2D(loc2);
                    }
                    if (!(Math.abs(loc1.z - loc2.z) > maxHeight)) continue;
                    maxHeight = Math.abs(loc1.z - loc2.z);
                }
            }
            if (maxDistance < this.minMovementDiameter && maxHeight < this.minMovementZ) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Bot stuck detected. Distance: " + maxDistance + " < " + this.minMovementDiameter + " && Height: " + maxHeight + " < " + this.minMovementZ);
                }
                this.stuck = true;
            } else {
                this.stuck = false;
            }
        }
    }

    @Override
    public boolean isStuck() {
        return this.stuck;
    }

    @Override
    public void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset.");
        }
        this.locationHistory.clear();
        this.stuck = false;
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, this);
        }

        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            UT2004PositionStuckDetector.this.eventSelf(event);
        }
    }
}

