/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.messages;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import eis.iilang.Identifier;
import eis.iilang.Parameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import nl.tudelft.goal.unreal.environment.UnrealEnvironmentException;
import nl.tudelft.goal.unreal.messages.Key;
import nl.tudelft.goal.unreal.messages.Parameters;
import nl.tudelft.goal.unreal.messages.StringList;

public final class EnvironmentParameters
extends Parameters
implements IComponent {
    private Level logLevel;
    private List<String> botNames;
    private URI visualizerServer;

    public EnvironmentParameters(IAgentLogger logger) {
        super(logger);
    }

    public EnvironmentParameters(Map<String, Parameter> parameters, IAgentLogger logger) throws UnrealEnvironmentException {
        super(parameters, logger);
    }

    @Override
    public void assignDefaults(IAgentParameters defaults) {
        super.assignDefaults(defaults);
        if (defaults instanceof EnvironmentParameters) {
            EnvironmentParameters parameters = (EnvironmentParameters)defaults;
            if (this.logLevel == null) {
                this.logLevel = parameters.getLogLevel();
            }
            if (this.botNames == null) {
                this.botNames = new ArrayList<String>(parameters.getBotNames());
            }
            if (this.visualizerServer == null) {
                this.visualizerServer = parameters.getVisualizerServer();
            }
        }
    }

    public IToken getComponentId() {
        return Tokens.get((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public List<String> getBotNames() {
        return this.botNames;
    }

    public void setVisualizerServer(URI uri) {
        this.visualizerServer = uri;
    }

    public URI getVisualizerServer() {
        return this.visualizerServer;
    }

    public URI getUTServer() {
        SocketConnectionAddress address = (SocketConnectionAddress)this.getWorldAddress();
        if (address.getHost() == null || address.getPort() == -1) {
            return null;
        }
        try {
            URI uri = new URI("ut://" + address.getHost() + ":" + address.getPort());
            return uri;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Parameter> map() {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        if (this.logLevel != null) {
            map.put(Key.LOGLEVEL.toString(), (Parameter)new Identifier(this.logLevel.toString()));
        }
        if (this.getAgentId() != null) {
            map.put(Key.CONTROLSERVERNAME.toString(), (Parameter)new Identifier((String)this.getAgentId().getName().getFlag()));
        }
        if (this.getWorldAddress() != null) {
            assert (this.getWorldAddress() instanceof ISocketConnectionAddress);
            ISocketConnectionAddress address = (ISocketConnectionAddress)this.getWorldAddress();
            String adressString = "ut://" + address.getHost() + ":" + address.getPort();
            map.put(Key.CONTROLSERVER.toString(), (Parameter)new Identifier(adressString));
        }
        assert (map.size() + 2 == Key.values().length) : "Missing values.";
        return map;
    }

    public Parameters setLogLevel(Level level) {
        assert (level != null);
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.LOGLEVEL, level}));
        this.logLevel = level;
        return this;
    }

    public Parameters setBotNames(List<String> botNames) {
        assert (botNames != null);
        this.botNames = new ArrayList<String>();
        this.botNames.addAll(botNames);
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.BOTNAMES, this.botNames}));
        return this;
    }

    @Override
    protected void setKey(Key key, Parameter value) throws TranslationException {
        switch (key) {
            case LOGLEVEL: {
                this.setLogLevel(value);
                break;
            }
            case CONTROLSERVER: {
                this.setWorldAddress(value);
                break;
            }
            case VISUALIZERSERVER: {
                this.setVisualizerServer(value);
                break;
            }
            case CONTROLSERVERNAME: {
                this.setServerName(value);
                break;
            }
            case BOTNAMES: {
                this.setBotNames(value);
                break;
            }
        }
    }

    private void setLogLevel(Parameter value) throws TranslationException {
        this.setLogLevel((Level)Translator.getInstance().translate2Java(value, Level.class));
    }

    private void setServerName(Parameter value) throws TranslationException {
        this.setAgentId((IAgentId)Translator.getInstance().translate2Java(value, AgentId.class));
    }

    private void setVisualizerServer(Parameter value) throws TranslationException {
        URI uri = (URI)Translator.getInstance().translate2Java(value, URI.class);
        this.setVisualizerServer(uri);
    }

    private void setBotNames(Parameter value) throws TranslationException {
        this.setBotNames((List)Translator.getInstance().translate2Java(value, StringList.class));
    }

    private void setWorldAddress(Parameter value) throws TranslationException {
        URI uri = (URI)Translator.getInstance().translate2Java(value, URI.class);
        this.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(uri));
    }

    public static EnvironmentParameters getDefaults(IAgentLogger log) {
        EnvironmentParameters parameters = new EnvironmentParameters(log);
        parameters.logLevel = Level.WARNING;
        parameters.botNames = new ArrayList<String>();
        parameters.visualizerServer = null;
        parameters.setAgentIdSilent("UnrealGoalEnvironmentControlServer");
        parameters.setWorldAddressSilent("127.0.0.1", 3001);
        return parameters;
    }

    private void setWorldAddressSilent(String host, int port) {
        super.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(host, port));
    }

    private void setAgentIdSilent(String name) {
        super.setAgentId((IAgentId)new AgentId(name));
    }
}

