/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.messages;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import eis.iilang.Parameter;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import nl.tudelft.goal.unreal.environment.UnrealEnvironmentException;
import nl.tudelft.goal.unreal.messages.Key;
import nl.tudelft.goal.unreal.messages.Parameters;
import nl.tudelft.goal.unreal.messages.Skin;
import nl.tudelft.goal.unreal.messages.Team;

public class BotParameters
extends Parameters
implements IComponent {
    private Level logLevel;
    private Boolean shouldLeadTarget;
    private Integer skill;
    private Skin skin;
    private Location location;
    private Rotation rotation;

    public BotParameters(IAgentLogger logger) {
        super(logger);
    }

    public BotParameters(Map<String, Parameter> parameters, IAgentLogger logger) throws UnrealEnvironmentException {
        super(parameters, logger);
    }

    public BotParameters(Parameters defaults, IAgentLogger logger) {
        super(logger);
        this.assignDefaults((IAgentParameters)defaults);
        if (this.getAgentId() != null) {
            String name = (String)this.getAgentId().getName().getFlag();
            this.setAgentId(name);
        }
    }

    @Override
    public void assignDefaults(IAgentParameters defaults) {
        super.assignDefaults(defaults);
        if (defaults instanceof BotParameters) {
            BotParameters parameters = (BotParameters)defaults;
            if (this.logLevel == null) {
                this.logLevel = parameters.getLogLevel();
            }
            if (this.shouldLeadTarget == null) {
                this.shouldLeadTarget = parameters.shouldLeadTarget();
            }
            if (this.skill == null) {
                this.skill = parameters.getSkill();
            }
            if (this.skin == null) {
                this.skin = parameters.getSkin();
            }
            if (this.location == null) {
                this.location = parameters.getStartLocation();
            }
            if (this.rotation == null) {
                this.rotation = parameters.getStartRotation();
            }
        }
    }

    public IToken getComponentId() {
        return Tokens.get((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public int getSkill() {
        return this.skill;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public BotParameters setLogLevel(Level level) {
        assert (level != null);
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.LOGLEVEL, level}));
        this.logLevel = level;
        return this;
    }

    public BotParameters setShouldLeadTarget(boolean shouldLeadTarget) {
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.LEADTARGET, shouldLeadTarget}));
        this.shouldLeadTarget = shouldLeadTarget;
        return this;
    }

    public BotParameters setSkill(int skill) {
        this.skill = Math.min(7, Math.max(skill, 0));
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.SKILL, this.skill}));
        return this;
    }

    public BotParameters setSkin(Skin skin) {
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.SKIN, skin.toString()}));
        this.skin = skin;
        return this;
    }

    public BotParameters setTeam(Team team) {
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.TEAM, team}));
        super.setTeam(Integer.valueOf(team.id()));
        return this;
    }

    public BotParameters setStartLocation(Location location) {
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.STARTLOCATION, location.toString()}));
        this.location = location;
        return this;
    }

    public BotParameters setStartRotation(Rotation rotation) {
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.STARTROTATION, rotation.toString()}));
        this.rotation = rotation;
        return this;
    }

    public Boolean shouldLeadTarget() {
        return this.shouldLeadTarget;
    }

    public Location getStartLocation() {
        return this.location;
    }

    public String toString() {
        return "BotParameters [logLevel=" + this.logLevel + ", shouldLeadTarget=" + this.shouldLeadTarget + ", skill=" + this.skill + ", skin=" + (Object)((Object)this.skin) + ", getTeam()=" + this.getTeam() + ", getWorldAddress()=" + this.getWorldAddress() + ", getAgentId()=" + this.getAgentId() + "]";
    }

    @Override
    protected void setKey(Key key, Parameter value) throws TranslationException {
        switch (key) {
            case LEADTARGET: {
                this.setShouldLeadTarget(value);
                break;
            }
            case LOGLEVEL: {
                this.setLogLevel(value);
                break;
            }
            case SKILL: {
                this.setSkill(value);
                break;
            }
            case SKIN: {
                this.setSkin(value);
                break;
            }
            case TEAM: {
                this.setTeam(value);
                break;
            }
            case BOTSERVER: {
                this.setWorldAddress(value);
                break;
            }
            case STARTLOCATION: {
                this.setStartLocation(value);
                break;
            }
            case STARTROTATION: {
                this.setStartRotation(value);
                break;
            }
        }
    }

    private void setStartRotation(Parameter value) throws TranslationException {
        this.setStartRotation((Rotation)Translator.getInstance().translate2Java(value, Rotation.class));
    }

    private void setStartLocation(Parameter value) throws TranslationException {
        this.setStartLocation((Location)Translator.getInstance().translate2Java(value, Location.class));
    }

    private void setLogLevel(Parameter value) throws TranslationException {
        this.setLogLevel((Level)Translator.getInstance().translate2Java(value, Level.class));
    }

    private void setShouldLeadTarget(Parameter value) throws TranslationException {
        this.setShouldLeadTarget((Boolean)Translator.getInstance().translate2Java(value, Boolean.class));
    }

    private void setSkill(Parameter value) throws TranslationException {
        this.setSkill((Integer)Translator.getInstance().translate2Java(value, Integer.class));
    }

    private void setSkin(Parameter value) throws TranslationException {
        this.setSkin((Skin)((Object)Translator.getInstance().translate2Java(value, Skin.class)));
    }

    private void setTeam(Parameter value) throws TranslationException {
        this.setTeam((Team)((Object)Translator.getInstance().translate2Java(value, Team.class)));
    }

    private void setWorldAddress(Parameter value) throws TranslationException {
        URI uri = (URI)Translator.getInstance().translate2Java(value, URI.class);
        this.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(uri));
    }

    public static BotParameters getDefaults(IAgentLogger logger) {
        BotParameters parameters = new BotParameters(logger);
        parameters.logLevel = Level.WARNING;
        parameters.shouldLeadTarget = true;
        parameters.skill = 3;
        parameters.skin = Skin.BotB;
        parameters.location = null;
        parameters.rotation = null;
        parameters.setAgentIdSilent("UnrealGoalBot");
        parameters.setWorldAddressSilent("127.0.0.1", 3000);
        return parameters;
    }

    private void setWorldAddressSilent(String host, int port) {
        super.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(host, port));
    }

    private void setAgentIdSilent(String name) {
        super.setAgentId((IAgentId)new AgentId(name));
    }

    public Rotation getStartRotation() {
        return this.rotation;
    }
}

