/**
 * BaseUnrealEnvironment, an implementation of the environment interface standard that 
 * facilitates the connection between GOAL and the UT2004 engine. 
 * 
 * Copyright (C) 2012 BaseUnrealEnvironment authors.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package nl.tudelft.goal.unreal.translators;

import java.util.HashMap;
import java.util.Map;

import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Java2Parameter;
import nl.tudelft.goal.EIS2Java.translation.Parameter2Java;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import eis.iilang.Identifier;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;

public class NavPointTranslator implements Parameter2Java<NavPoint>, Java2Parameter<NavPoint> {

	/**
	 * To translate from Parameter2Java we are given an UnrealId. However we can
	 * not access the agents memory during translation. To work around this we
	 * store everything we have send to any agent.
	 */
	protected Map<WorldObjectId, NavPoint> navPoints = new HashMap<WorldObjectId, NavPoint>();


	@Override
	public Parameter[] translate(NavPoint o) throws TranslationException {
		navPoints.put(o.getId(), o);

		ParameterList neightbours = new ParameterList();
		for (UnrealId id : o.getOutgoingEdges().keySet()) {
			neightbours.add(new Identifier(id.getStringId()));
		}

		// navpoint(<UnrealID>, <Position>, [<Neigs-UnrealID>])
		return new Parameter[] { new Identifier(o.getId().getStringId()),
				Translator.getInstance().translate2Parameter(o.getLocation())[0], neightbours };
	}

	@Override
	public NavPoint translate(Parameter p) throws TranslationException {

		UnrealId id = Translator.getInstance().translate2Java(p, UnrealId.class);

		NavPoint navPoint = navPoints.get(id);

		if (navPoint == null) {
			String message = String
					.format("The identifier must be the unrealID of a navpoint that has been translated once, received: %s.",
							p);
			throw new TranslationException(message);
		}

		return navPoint;
	}

	@Override
	public Class<NavPoint> translatesFrom() {
		return NavPoint.class;
	}

	@Override
	public Class<NavPoint> translatesTo() {
		return NavPoint.class;
	}

}