/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.visualizer.gui.panels;

import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableSet;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.data.EnvironmentData;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;

public class EnvironmentPanel
extends JPanel {
    private JList connected;

    public EnvironmentPanel() {
        EnvironmentData data = ServerController.getInstance().getEnvironmentData();
        data.getEnvironments().addCollectionListener((CollectionEventListener)new CollectionEventAdaptor<EnvironmentService>(){

            @Override
            public void postAddEvent(Collection<EnvironmentService> alreadyAdded, Collection<EnvironmentService> whereWereAdded) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnvironmentPanel.this.updateText();
                    }
                });
            }

            @Override
            public void postRemoveEvent(Collection<EnvironmentService> alreadyAdded, Collection<EnvironmentService> whereWereRemoved) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnvironmentPanel.this.updateText();
                    }
                });
            }
        });
        this.updateText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText() {
        EnvironmentData environments = ServerController.getInstance().getEnvironmentData();
        ObservableSet<EnvironmentService> clients = environments.getEnvironments();
        this.removeAll();
        ObservableSet<EnvironmentService> observableSet = clients;
        synchronized (observableSet) {
            this.connected = new JList<Object>(clients.toArray());
        }
        this.add(this.connected);
    }
}

