/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;

public class SelectableEnvironment {
    private final EnvironmentService environment;

    public SelectableEnvironment(EnvironmentService environment) {
        this.environment = environment;
    }

    public EnvironmentService getItem() {
        return this.environment;
    }

    private String simplefyID(String id) {
        int index = id.lastIndexOf(47);
        if (index < 0) {
            index = id.length();
        }
        return id.substring(0, index);
    }

    public String toString() {
        try {
            return this.simplefyID(this.environment.getAgentId().getToken());
        }
        catch (RemoteException e) {
            return "Unconnected Environment";
        }
    }

    public static Collection<SelectableEnvironment> fromCollection(Collection<? extends EnvironmentService> environments) {
        ArrayList<SelectableEnvironment> ret = new ArrayList<SelectableEnvironment>(environments.size());
        for (EnvironmentService environmentService : environments) {
            ret.add(new SelectableEnvironment(environmentService));
        }
        return ret;
    }
}

