/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.widgets;

import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Waypoint;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.data.GameData;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.SuggestionField;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.SuggestionModel;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;
import nl.tudelft.goal.ut2004.visualizer.util.SelectableWayPoint;

public class WaypointBox
extends JPanel {
    private final SuggestionField suggestionField;
    private final Listener listener = new Listener();
    private final ObservableCollection<Waypoint> waypoints;
    private final SuggestionModel suggestionModel = new SuggestionModel();

    public WaypointBox() {
        this.suggestionField = new SuggestionField(this.suggestionModel);
        this.add(this.suggestionField);
        ServerController controller = ServerController.getInstance();
        GameData data = controller.getGameData();
        this.waypoints = data.getWaypoints();
        this.waypoints.addCollectionListener((CollectionEventListener)this.listener);
        this.addAll((Collection<Waypoint>)this.waypoints);
    }

    public Waypoint getSelected() {
        SelectableWayPoint sw = (SelectableWayPoint)this.suggestionModel.getSelectedItem();
        if (sw != null) {
            return sw.getWaypoint();
        }
        return null;
    }

    public void setSelected(Object item) {
        if (item instanceof Waypoint) {
            item = new SelectableWayPoint((Waypoint)item);
        }
        this.suggestionField.setSelectedItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(Collection<Waypoint> waypoints) {
        Collection<Waypoint> collection = waypoints;
        synchronized (collection) {
            for (Waypoint w : waypoints) {
                this.suggestionModel.addElement(new SelectableWayPoint(w));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll(Collection<Waypoint> waypoints) {
        Collection<Waypoint> collection = waypoints;
        synchronized (collection) {
            for (Waypoint w : waypoints) {
                this.suggestionModel.removeElement(new SelectableWayPoint(w));
            }
        }
    }

    public void dispose() {
        this.waypoints.removeCollectionListener((CollectionEventListener)this.listener);
    }

    private class Listener
    extends CollectionEventAdaptor<Waypoint> {
        private Listener() {
        }

        @Override
        public void postRemoveEvent(final Collection<Waypoint> alreadyRemoved, Collection<Waypoint> whereWereRemoved) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaypointBox.this.removeAll(alreadyRemoved);
                }
            });
        }

        @Override
        public void postAddEvent(final Collection<Waypoint> alreadyAdded, Collection<Waypoint> whereWereAdded) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaypointBox.this.addAll(alreadyAdded);
                }
            });
        }
    }
}

