/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.JavaBehaviour;
import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.ILogicWorkExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BehaviorWorkExecutor
implements ILogicWorkExecutor {
    protected final HashMap<String, BehaviorMethod> primitives = new HashMap();
    protected List<JavaBehaviour> behaviors = new ArrayList<JavaBehaviour>();

    public BehaviorWorkExecutor() {
    }

    public BehaviorWorkExecutor(JavaBehaviour behavior) {
        this.addBehavior(behavior);
    }

    public synchronized void addBehavior(JavaBehaviour behavior) {
        Method[] methods;
        this.behaviors.add(behavior);
        for (Method method : methods = behavior.getClass().getMethods()) {
            boolean isAnnotated = method.isAnnotationPresent(SPOSHAction.class) || method.isAnnotationPresent(SPOSHSense.class);
            String name = method.getName();
            if (!isAnnotated) continue;
            if (this.primitives.containsKey(name)) {
                throw new IllegalArgumentException("primitive name clash (there are at least 2 primitives with name \"" + name + "\")");
            }
            this.primitives.put(name, new BehaviorMethod(behavior, method));
        }
    }

    private Object executePrimitive(String primitive, VariableContext ctx) {
        Class<?> firstParameterClass;
        BehaviorMethod behaviorMethod = this.primitives.get(primitive);
        if (behaviorMethod == null) {
            throw new IllegalArgumentException("Primitive \"" + primitive + "\" has no behavior method.");
        }
        Method method = behaviorMethod.method;
        Object[] args = new Object[method.getParameterTypes().length];
        if (method.getParameterTypes().length > 0 && (firstParameterClass = method.getParameterTypes()[0]).equals(VariableContext.class)) {
            args[0] = ctx;
        }
        try {
            return method.invoke(behaviorMethod.behavior, args);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public Object executeSense(String primitive, VariableContext ctx) {
        return this.executePrimitive(primitive, ctx);
    }

    @Override
    public ActionResult executeAction(String primitive, VariableContext ctx) {
        return (ActionResult)((Object)this.executePrimitive(primitive, ctx));
    }

    @Override
    public void logicAfterPlan() {
        for (JavaBehaviour behavior : this.behaviors) {
            behavior.logicAfterPlan();
        }
    }

    @Override
    public void logicBeforePlan() {
        for (JavaBehaviour behavior : this.behaviors) {
            behavior.logicBeforePlan();
        }
    }

    protected class BehaviorMethod {
        public final Object behavior;
        public final Method method;

        public BehaviorMethod(Object behavior, Method method) {
            this.behavior = behavior;
            this.method = method;
        }
    }
}

