/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pathfinding.alg.floydwarshall;

import cz.cuni.amis.pathfinding.map.IPFKnownMap;
import cz.cuni.amis.pathfinding.map.IPFKnownMapView;
import cz.cuni.amis.utils.Iterators;
import cz.cuni.amis.utils.NullCheck;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FloydWarshall<NODE> {
    private IPFKnownMap<NODE> map;
    private IPFKnownMapView<NODE> view;
    private Logger log = null;
    private Map<NODE, Integer> nodesIndices;
    private Map<Integer, NODE> indicesNodes;
    private PathMatrixNode<NODE>[][] pathMatrix;

    public FloydWarshall(IPFKnownMap<NODE> map) {
        this.map = map;
        this.view = new IPFKnownMapView.DefaultView();
        NullCheck.check(this.map, "map");
        this.compute();
    }

    public FloydWarshall(IPFKnownMap<NODE> map, IPFKnownMapView<NODE> view) {
        this.map = map;
        this.view = view;
        NullCheck.check(this.map, "map");
        if (this.view == null) {
            this.view = new IPFKnownMapView.DefaultView();
        }
        this.compute();
    }

    public FloydWarshall(IPFKnownMap<NODE> map, Logger log) {
        this.map = map;
        this.view = new IPFKnownMapView.DefaultView();
        NullCheck.check(this.map, "map");
        this.log = log;
        this.compute();
    }

    public FloydWarshall(IPFKnownMap<NODE> map, IPFKnownMapView<NODE> view, Logger log) {
        this.map = map;
        this.view = view;
        NullCheck.check(this.map, "map");
        this.log = log;
        if (this.view == null) {
            if (log != null && log.isLoggable(Level.WARNING)) {
                log.warning("No view specified! IPFKnownMapView.DefaultView is going to be used.");
            }
            this.view = new IPFKnownMapView.DefaultView();
        }
        this.compute();
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public IPFKnownMap<NODE> getMap() {
        return this.map;
    }

    public synchronized void setMap(IPFKnownMap<NODE> map) {
        this.map = map;
    }

    public IPFKnownMapView<NODE> getMapView() {
        return this.view;
    }

    public synchronized void setMapView(IPFKnownMapView<NODE> mapView) {
        this.view = mapView;
    }

    public synchronized void compute() {
        Collection<NODE> extraNodes;
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Computing paths...");
        }
        ArrayList<NODE> nodes = new ArrayList<NODE>();
        Collection<NODE> mapNodes = this.map.getNodes();
        if (mapNodes != null) {
            for (NODE node : mapNodes) {
                if (!this.view.isNodeOpened(node)) continue;
                nodes.add(node);
            }
        }
        if ((extraNodes = this.view.getExtraNodes(mapNodes)) != null) {
            for (NODE node : extraNodes) {
                if (!this.view.isNodeOpened(node)) continue;
                nodes.add(node);
            }
        }
        this.performFloydWarshall(nodes);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Paths computed!");
        }
    }

    public synchronized void cacheAllPaths() {
        int size = this.pathMatrix.length;
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Caching all paths O(" + size + "^3)...");
        }
        long time2 = System.currentTimeMillis();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (this.pathMatrix[i][j].getPathCost() == Integer.MAX_VALUE) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.warning("Unreachable path from " + this.indicesNodes.get(i) + " -> " + this.indicesNodes.get(j));
                    }
                    ++count;
                    continue;
                }
                this.pathMatrix[i][j].setPath(this.retrievePath(i, j));
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Paths cached (" + (System.currentTimeMillis() - time2) + " ms).");
        }
    }

    private void performFloydWarshall(List<NODE> nodes) {
        int i;
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Running Floyd-Warshall algorithm...");
        }
        long start = System.currentTimeMillis();
        int size = nodes.size();
        this.nodesIndices = new HashMap<NODE, Integer>(size);
        this.indicesNodes = new HashMap<Integer, NODE>(size);
        this.pathMatrix = new PathMatrixNode[size][size];
        for (i = 0; i < nodes.size(); ++i) {
            this.nodesIndices.put(nodes.get(i), i);
            this.indicesNodes.put(i, nodes.get(i));
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Initializing matrix...");
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.pathMatrix[i][j] = new PathMatrixNode(i == j ? 0 : Integer.MAX_VALUE);
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Setting initial arc costs...");
        }
        for (i = 0; i < size; ++i) {
            NODE node1 = nodes.get(i);
            if (!this.view.isNodeOpened(node1)) continue;
            Collection<NODE> neighbors = this.map.getNeighbors(node1);
            Collection<NODE> extraNeighbors = this.view.getExtraNeighbors(node1, neighbors);
            Iterators iterator = new Iterators(neighbors == null ? null : neighbors.iterator(), extraNeighbors == null ? null : extraNeighbors.iterator());
            while (iterator.hasNext()) {
                Object node2 = iterator.next();
                if (!this.view.isNodeOpened(node2) || !this.view.isArcOpened(node1, node2)) continue;
                int j = this.nodesIndices.get(node2);
                int arcCost = this.map.getArcCost(node1, node2);
                arcCost += this.view.getArcExtraCost(node1, node2, arcCost);
                int nodeCost = this.map.getNodeCost(node2);
                nodeCost += this.view.getNodeExtraCost(node2, nodeCost);
                this.pathMatrix[i][j].setPathCost(arcCost + nodeCost);
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Computing path-matrix O(" + size + "^3)...");
        }
        for (int k = 0; k < size; ++k) {
            for (int i2 = 0; i2 < size; ++i2) {
                NODE node1 = nodes.get(i2);
                NODE node2 = nodes.get(k);
                for (int j = 0; j < size; ++j) {
                    int newLen;
                    NODE node3 = nodes.get(j);
                    int n = this.pathMatrix[i2][k].getPathCost() == Integer.MAX_VALUE ? Integer.MAX_VALUE : (newLen = this.pathMatrix[k][j].getPathCost() == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.pathMatrix[i2][k].getPathCost() + this.pathMatrix[k][j].getPathCost());
                    if (this.pathMatrix[i2][j].getPathCost() <= newLen) continue;
                    this.pathMatrix[i2][j].setPathCost(newLen);
                    this.pathMatrix[i2][j].setViaNode(k);
                }
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Checking reachability...");
        }
        int count = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            for (int j = 0; j < size; ++j) {
                if (this.pathMatrix[i3][j].getPathCost() != Integer.MAX_VALUE) continue;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.warning("Unreachable path from " + nodes.get(i3) + " -> " + nodes.get(j));
                }
                ++count;
            }
        }
        if (count > 0) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(this + ": There are " + count + " unreachable nodes pairs (if you wish to see their list, set logging to Level.FINER).");
            }
        } else if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(this + ": All nodes are connected, there are NO unreachable pairs of nodes.");
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(this + ": Computation for " + size + " navpoints took " + (System.currentTimeMillis() - start) + " millis.");
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(this + ": Memory consumption (no paths cached) is aprox. " + this.getAproxMemory() + " bytes, might be as twice as much for 64-bit system.");
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Floyd-Warshall algorithm finished!");
        }
    }

    public long getAproxMemory() {
        long bytes = 0L;
        for (int i = 0; i < this.pathMatrix.length; ++i) {
            for (int j = 0; j < this.pathMatrix.length; ++j) {
                bytes += (long)this.pathMatrix[i][j].getBytesAprox();
            }
        }
        return bytes += (long)(this.pathMatrix.length * 8 * 2);
    }

    private List<NODE> retrievePathInner(Integer from, Integer to) {
        PathMatrixNode<NODE> node = this.pathMatrix[from][to];
        if (node.getPathCost() == Integer.MAX_VALUE) {
            return null;
        }
        if (node.getViaNode() == null) {
            return new ArrayList(0);
        }
        if (node.getViaNode() == null) {
            return new ArrayList(0);
        }
        ArrayList<NODE> path = new ArrayList<NODE>();
        path.addAll(this.retrievePathInner(from, node.getViaNode()));
        path.add(this.indicesNodes.get(node.getViaNode()));
        path.addAll(this.retrievePathInner(node.getViaNode(), to));
        return path;
    }

    private List<NODE> retrievePath(Integer from, Integer to) {
        ArrayList<NODE> path = new ArrayList<NODE>();
        path.add(this.indicesNodes.get(from));
        path.addAll(this.retrievePathInner(from, to));
        path.add(this.indicesNodes.get(to));
        return path;
    }

    public PathMatrixNode<NODE> getPathMatrixNode(NODE nodeFrom, NODE nodeTo) {
        Integer from = this.nodesIndices.get(nodeFrom);
        Integer to = this.nodesIndices.get(nodeTo);
        if (from == null || to == null) {
            return null;
        }
        return this.pathMatrix[from][to];
    }

    public boolean isReachable(NODE from, NODE to) {
        if (from == null || to == null) {
            return false;
        }
        PathMatrixNode<NODE> matrixNode = this.getPathMatrixNode(from, to);
        if (matrixNode == null) {
            return false;
        }
        return matrixNode.getPathCost() != Integer.MAX_VALUE;
    }

    public int getPathCost(NODE from, NODE to) {
        if (from == null || to == null) {
            return Integer.MAX_VALUE;
        }
        PathMatrixNode<NODE> matrixNode = this.getPathMatrixNode(from, to);
        if (matrixNode == null) {
            return Integer.MAX_VALUE;
        }
        return matrixNode.getPathCost();
    }

    public List<NODE> getPath(NODE from, NODE to) {
        PathMatrixNode<NODE> matrixNode;
        if (from == null || to == null) {
            return null;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Retrieving path: " + from + " -> " + to);
        }
        if ((matrixNode = this.getPathMatrixNode(from, to)) == null) {
            return null;
        }
        if (matrixNode.getPathCost() == Integer.MAX_VALUE) {
            return null;
        }
        List<NODE> path = matrixNode.getPath();
        if (path == null) {
            path = this.retrievePathInner(this.nodesIndices.get(from), this.nodesIndices.get(to));
            matrixNode.setPath(path);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Path " + from + " -> " + to + " exists, " + path.size() + " nodes long.");
        }
        return path;
    }

    public PathMatrixNode<NODE>[][] getMatrix() {
        return this.pathMatrix;
    }

    public Integer getNodeIndex(NODE node) {
        return this.nodesIndices.get(node);
    }

    public String toString() {
        return "FloydWarshall";
    }

    public static class PathMatrixNode<N> {
        private int cost = Integer.MAX_VALUE;
        private Integer viaNode = null;
        private SoftReference<List<N>> path = null;

        public PathMatrixNode() {
        }

        public PathMatrixNode(int cost) {
            this.cost = cost;
        }

        public int getBytesAprox() {
            List<N> path = this.path != null ? this.path.get() : null;
            return 12 + (path == null ? 4 : 4 + path.size() * 4);
        }

        public int getBytesAproxWithoutPath() {
            List<N> path = this.path != null ? this.path.get() : null;
            return 16;
        }

        public int getPathCost() {
            return this.cost;
        }

        public void setPathCost(int cost) {
            this.cost = cost;
        }

        public Integer getViaNode() {
            return this.viaNode;
        }

        public void setViaNode(Integer indice) {
            this.viaNode = indice;
        }

        public List<N> getPath() {
            return this.path == null ? null : this.path.get();
        }

        public void setPath(List<N> path) {
            this.path = new SoftReference<List<N>>(path);
        }
    }
}

