/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.IConditionElement;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

public final class CompetenceElement
extends PoshDummyElement<CompetenceElement, Competence>
implements INamedElement,
IConditionElement<CompetenceElement> {
    private String name;
    @Deprecated
    private int retries;
    @Deprecated
    private String comment;
    private final Trigger<CompetenceElement> trigger = new Trigger<CompetenceElement>(this);
    private final TriggeredAction action;
    public static final String ceName = "ceName";
    public static final String ceRetries = "ceRetries";
    public static final String ceComment = "ceComment";
    public static final DataFlavor dataFlavor = new DataFlavor(CompetenceElement.class, "competence-element");
    public static final int INFINITE_RETRIES = -1;

    public CompetenceElement(String name, List<Sense> triggerSenses, PrimitiveCall actionCall, int retries, String comment) {
        assert (name != null);
        assert (comment != null);
        this.name = name;
        this.retries = retries;
        this.comment = comment;
        this.action = LapElementsFactory.createAction(actionCall);
        this.action.setParent(this);
        for (Sense sense : triggerSenses) {
            this.trigger.add(sense);
        }
    }

    public Trigger<CompetenceElement> getTrigger() {
        return this.trigger;
    }

    @Override
    public Trigger<CompetenceElement> getCondition() {
        return this.getTrigger();
    }

    public TriggeredAction getAction() {
        return this.action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.name);
        if (!this.trigger.isEmpty()) {
            sb.append(" (trigger ");
            sb.append(this.trigger.toString());
            sb.append(')');
        }
        sb.append(' ');
        sb.append(this.action.toString());
        if (this.retries != -1) {
            sb.append(' ');
            sb.append(this.retries);
        }
        if (!this.comment.isEmpty()) {
            sb.append(" \"");
            sb.append(this.comment);
            sb.append('\"');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>(this.trigger);
        children.add((Sense)((Object)this.action));
        return children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws InvalidNameException, DuplicateNameException {
        if (!(name = name.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw InvalidNameException.create(name);
        }
        boolean isSameName = this.name.equals(name);
        if (this.getParent() != null && CompetenceElement.isUsedName(name, ((Competence)this.getParent()).getChildDataNodes()) && !isSameName) {
            throw new DuplicateNameException("Choice with " + name + " already exists in competence " + ((Competence)this.getParent()).getName());
        }
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(ceName, oldName, name);
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        assert (child instanceof Sense);
        this.trigger.moveSense(newIndex, (Sense)child);
        return true;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public LapType getType() {
        return LapType.COMPETENCE_ELEMENT;
    }

    @Deprecated
    public int getRetries() {
        return this.retries;
    }

    @Deprecated
    public void setRetries(int newRetries) {
        assert (newRetries >= 0 || newRetries == -1);
        int oldValue = this.retries;
        this.retries = newRetries;
        this.firePropertyChange(ceRetries, oldValue, newRetries);
    }

    @Deprecated
    public String getComment() {
        return this.comment;
    }

    @Deprecated
    public void setComment(String newComment) {
        assert (newComment != null);
        String oldComment = this.comment;
        this.comment = newComment;
        this.firePropertyChange(ceComment, oldComment, newComment);
    }
}

