/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IConditionElement;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.MissingParameterException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

public class Adopt
extends PoshDummyElement<Adopt, PoshPlan>
implements IParametrizedElement,
IConditionElement<Adopt> {
    public static final DataFlavor dataFlavor = new DataFlavor(Adopt.class, "adopt-node");
    public static final String adName = "adName";
    public static final String adParams = "adParams";
    private String name;
    private FormalParameters parameters;
    private Trigger<Adopt> exitCondition;
    private final TriggeredAction adoptedElement;

    public Adopt(String name, FormalParameters parameters, List<Sense> exitCondition, PrimitiveCall adoptedElement) {
        this.name = name;
        this.parameters = parameters;
        this.exitCondition = new Trigger<Adopt>(this, exitCondition);
        this.adoptedElement = LapElementsFactory.createAction(adoptedElement);
        this.adoptedElement.setParent(this);
    }

    @Override
    public FormalParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(FormalParameters newParams) throws MissingParameterException {
        FormalParameters oldParams = this.parameters;
        Arguments args = this.adoptedElement.getArguments();
        for (Arguments.Argument arg : args) {
            String valueVariableName = arg.getParameterVariable();
            if (valueVariableName == null || newParams.containsVariable(valueVariableName)) continue;
            throw new MissingParameterException(valueVariableName);
        }
        this.parameters = newParams;
        this.firePropertyChange(adParams, oldParams, newParams);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws InvalidNameException, DuplicateNameException, CycleException {
        PoshPlan plan = this.getRootNode();
        if (!(name = name.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw new InvalidNameException("Name " + name + " is not valid.");
        }
        if (!this.name.equals(name) && plan != null && !plan.isUniqueNodeName(name)) {
            throw new DuplicateNameException("New name for adopt '" + this.name + "'(" + name + ") is not unique for reaction plan.");
        }
        String oldName = this.name;
        this.name = name;
        if (plan != null && plan.isCycled()) {
            this.name = oldName;
            throw new CycleException("New name (" + name + ") for adopt '" + this.name + "' is causing cycle.");
        }
        this.firePropertyChange(adName, oldName, name);
    }

    public void addCondition(Sense sense) {
        this.exitCondition.add(sense);
    }

    public Trigger<Adopt> getExitCondition() {
        return this.exitCondition;
    }

    @Override
    public Trigger<Adopt> getCondition() {
        return this.getExitCondition();
    }

    public TriggeredAction getAdoptedElement() {
        return this.adoptedElement;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public LapType getType() {
        return LapType.ADOPT;
    }

    @Override
    public List<? extends PoshElement> getChildDataNodes() {
        ArrayList<PoshDummyElement> children = new ArrayList<PoshDummyElement>();
        children.addAll(this.exitCondition);
        children.add(this.adoptedElement);
        return children;
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        throw new UnsupportedOperationException("Moving Adopt doesn't make sense.");
    }
}

