/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.messages.SharedBatchBeginEvent;
import cz.cuni.amis.pogamut.multi.communication.messages.SharedBatchFinishedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.VisionLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalViewable;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.event.DummyObjectEvent;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BatchAwareLocalWorldView
extends VisionLocalWorldView {
    private Queue<List<IWorldChangeEvent>> batches = new LinkedBlockingQueue<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new LinkedList<IWorldChangeEvent>();
    private boolean lockRequested = false;
    private boolean lockFinished = false;
    private boolean waitingForSharedBatch = false;
    private Set<Long> sharedWVLocks = Collections.synchronizedSet(new HashSet(4));
    private boolean timeKeyIncreased = false;
    private Object objectMutex = new Object();
    private CountDownLatch latch = new CountDownLatch(1);
    private List<Long> lockedTimes = new LinkedList<Long>();
    protected Map<WorldObjectId, Set<DummyObjectEvent.EventType>> bufferedEvents = new HashMap<WorldObjectId, Set<DummyObjectEvent.EventType>>();
    protected List<DummyObjectEvent> eventBuffer = new LinkedList<DummyObjectEvent>();
    IWorldChangeEvent bufferedEndMessage = null;
    private boolean timeKeySet = false;
    boolean endMessageCame = false;
    boolean sharedFinished = false;

    public BatchAwareLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView parentWorldView, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, parentWorldView, agentId);
        this.objectMutex = new Object();
    }

    protected abstract boolean isBatchBeginEvent(IWorldChangeEvent var1);

    protected abstract boolean isBatchEndEvent(IWorldChangeEvent var1);

    protected synchronized void notifySharedBegin(long time2) {
        this.log.finer("Notifying sharedWorldView with SharedBegin event of time : " + time2);
        this.sharedWorldView.notify(new SharedBatchBeginEvent(time2, this.agentId));
    }

    @Override
    protected void objectCreated(ILocalWorldObject obj, long time2) {
        this.bufferObjectEvent(obj.getId(), DummyObjectEvent.EventType.FIRST_ENCOUNTERED, time2);
        this.bufferObjectEvent(obj.getId(), DummyObjectEvent.EventType.UPDATED, time2);
        super.objectCreated(obj, time2);
    }

    @Override
    protected void objectUpdated(ILocalWorldObject obj, long time2) {
        this.bufferObjectEvent(obj.getId(), DummyObjectEvent.EventType.UPDATED, time2);
        super.objectUpdated(obj, time2);
    }

    @Override
    protected void objectDestroyed(ILocalWorldObject obj, long time2) {
        this.raiseEvent(new WorldObjectDestroyedEvent<ICompositeWorldObject>(this.get(obj.getId(), TimeKey.get(time2)), time2));
        super.objectDestroyed(obj, time2);
    }

    @Override
    protected void objectAppeared(ILocalViewable obj, long time2) {
        super.objectAppeared(obj, time2);
        this.bufferObjectEvent(obj.getId(), DummyObjectEvent.EventType.APPEARED, time2);
    }

    @Override
    protected void objectDisappeared(ILocalViewable obj, long time2) {
        super.objectDisappeared(obj, time2);
        this.bufferObjectEvent(obj.getId(), DummyObjectEvent.EventType.DISAPPEARED, time2);
    }

    protected abstract void disappearObject(WorldObjectId var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bufferObjectEvent(WorldObjectId id, DummyObjectEvent.EventType eventType, long time2) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Buffering event for : " + id.toString() + " ; Type :" + eventType.toString() + "; T : " + time2);
        }
        List<DummyObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            Set<DummyObjectEvent.EventType> buffered = this.bufferedEvents.get(id);
            if (buffered == null) {
                this.eventBuffer.add(new DummyObjectEvent(id, eventType, time2));
                buffered = new HashSet<DummyObjectEvent.EventType>();
                buffered.add(eventType);
                this.bufferedEvents.put(id, buffered);
            } else if (!buffered.contains((Object)eventType)) {
                buffered.add(eventType);
                this.eventBuffer.add(new DummyObjectEvent(id, eventType, time2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEvents() {
        LinkedList<DummyObjectEvent> toBuffer = new LinkedList<DummyObjectEvent>();
        if (this.log.isLoggable(Level.FINE)) {
            if (this.eventBuffer.isEmpty()) {
                this.log.fine("No events to flush.");
            } else {
                this.log.fine("Flushing events for time : " + this.eventBuffer.iterator().next().getTime() + "; Buffer size : " + this.eventBuffer.size());
            }
        }
        List<DummyObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            List<DummyObjectEvent> toProcess = this.eventBuffer;
            this.eventBuffer = new LinkedList<DummyObjectEvent>();
            for (DummyObjectEvent dummy : toProcess) {
                WorldObjectEvent e = null;
                long eventTime = dummy.getTime();
                try {
                    switch (dummy.getType()) {
                        case APPEARED: {
                            e = new WorldObjectAppearedEvent<IViewable>((IViewable)this.get(dummy.getObjectId(), TimeKey.get(eventTime)), eventTime);
                            break;
                        }
                        case DESTROYED: {
                            e = new WorldObjectDestroyedEvent<ICompositeWorldObject>(this.get(dummy.getObjectId(), TimeKey.get(eventTime)), eventTime);
                            break;
                        }
                        case DISAPPEARED: {
                            this.disappearObject(dummy.getObjectId(), eventTime);
                            break;
                        }
                        case FIRST_ENCOUNTERED: {
                            e = new WorldObjectFirstEncounteredEvent<ICompositeWorldObject>(this.get(dummy.getObjectId(), TimeKey.get(eventTime)), eventTime);
                            break;
                        }
                        case UPDATED: {
                            if (this.getLocal(dummy.getObjectId()) == null) break;
                            e = new WorldObjectUpdatedEvent<ICompositeWorldObject>(this.get(dummy.getObjectId(), TimeKey.get(eventTime)), eventTime);
                        }
                    }
                    if (e == null) continue;
                    this.raiseEvent(e);
                }
                catch (Exception exc) {
                    this.log.warning("[" + dummy.getTime() + "]Exception in raising event |" + dummy.getObjectId() + "| postponing " + exc);
                    dummy.incTime();
                    toBuffer.add(dummy);
                }
            }
            this.eventBuffer.addAll(toBuffer);
            this.bufferedEvents = new HashMap<WorldObjectId, Set<DummyObjectEvent.EventType>>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sharedBatchFinished(long time2) {
        if (this.lockedTimes == null) {
            this.lockedTimes = new LinkedList<Long>();
        }
        List<Long> list = this.lockedTimes;
        synchronized (list) {
            this.flushEvents();
            NullCheck.check(this.bufferedEndMessage, "Buffered End message");
            super.notify(this.bufferedEndMessage);
            this.bufferedEndMessage = null;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("SharedBatchFinishedEvent recieved from the SharedWorldView for time " + time2);
            }
            if (!this.lockFinished) {
                this.log.fine("Setting current timeKey : " + time2);
                this.setCurrentTime(TimeKey.get(time2));
                this.timeKeyIncreased = true;
                LinkedList<Long> newLocks = new LinkedList<Long>();
                for (Long t : this.lockedTimes) {
                    if (t < time2) {
                        this.unlockTime(t);
                        continue;
                    }
                    newLocks.add(t);
                }
                this.lockedTimes = newLocks;
                if (this.latch == null) {
                    this.latch = new CountDownLatch(1);
                }
                this.latch.countDown();
            }
        }
    }

    public boolean isLocked() {
        return this.lockFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        this.log.fine("Locking BatchAwareLocalWorldView");
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isRunning()) {
                throw new ComponentNotRunningException("Can't lock() world view is not running!", (Logger)this.log, (Object)this);
            }
            if (this.lockFinished) {
                return;
            }
            this.lockRequested = true;
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException("Interrupted while waiting to acquire lock()!", e, (Object)this);
        }
        this.lockFinished = true;
        this.log.fine("BatchAwareLocalWorldView locked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isRunning()) {
                throw new ComponentNotRunningException("Can't unlock() world view is not running!", (Logger)this.log, (Object)this);
            }
            LinkedList<Long> newLocks = new LinkedList<Long>();
            for (Long t : this.lockedTimes) {
                if (t < this.currentTimeKey.getTime()) {
                    this.unlockTime(t);
                    continue;
                }
                newLocks.add(t);
            }
            this.lockedTimes = newLocks;
            this.lockFinished = false;
            this.lockRequested = false;
            this.latch = new CountDownLatch(1);
            this.log.fine("BatchAwareLocalWorldView unlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notify(IWorldChangeEvent event) {
        this.log.finest("BatchAwareLocalWorldView notify : " + event);
        if (!this.timeKeySet) {
            this.currentTimeKey = TimeKey.get(event.getSimTime());
            this.timeKeySet = true;
        }
        if (!(event instanceof ILocalWorldObjectUpdatedEvent)) {
            if (event instanceof ICompositeWorldObjectUpdatedEvent) {
                IWorldChangeEvent partEvent = ((ICompositeWorldObjectUpdatedEvent)event).getSharedEvent();
                if (partEvent != null) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Notyfying sharedWV " + partEvent.toString() + ")");
                    }
                    this.sharedWorldView.notify(partEvent);
                }
                if ((partEvent = ((ICompositeWorldObjectUpdatedEvent)event).getStaticEvent()) != null) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Notyfying sharedWV " + partEvent.toString() + ")");
                    }
                    this.sharedWorldView.notify(partEvent);
                }
            } else if (event instanceof ISharedWorldObjectUpdatedEvent || event instanceof IStaticWorldObjectUpdatedEvent) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                }
                this.sharedWorldView.notify(event);
                return;
            }
        }
        if (this.objectMutex == null) {
            this.objectMutex = new Object();
        }
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isBatchBeginEvent(event)) {
                if (this.currentTimeKey == null) {
                    this.log.info("Setting new currentTimeKey to : " + event.getSimTime());
                    this.currentTimeKey = TimeKey.get(event.getSimTime());
                }
                this.lockTime(event.getSimTime());
                this.lockedTimes.add(event.getSimTime());
                this.notifySharedBegin(event.getSimTime());
                super.notify(event);
            } else if (this.isBatchEndEvent(event)) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Notifying sharedWorldView with EndEvent of time " + event.getSimTime() + " : " + event);
                }
                this.sharedWorldView.notify(event);
                this.bufferedEndMessage = event;
                this.endMessageCame = true;
                if (this.endMessageCame && this.sharedFinished) {
                    this.sharedBatchFinished(event.getSimTime());
                    this.endMessageCame = false;
                    this.sharedFinished = false;
                }
            } else if (event instanceof SharedBatchFinishedEvent) {
                this.sharedFinished = true;
                if (this.endMessageCame && this.sharedFinished) {
                    this.sharedBatchFinished(event.getSimTime());
                    this.endMessageCame = false;
                    this.sharedFinished = false;
                }
            } else {
                super.notify(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stop() {
        super.stop();
        Object object = this.objectMutex;
        synchronized (object) {
            while (this.latch != null && this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            while (this.lockedTimes != null && this.lockedTimes.size() > 0) {
                long time2 = this.lockedTimes.get(0);
                this.unlockTime(this.lockedTimes.get(0));
                if (this.lockedTimes.get(0) != time2) continue;
                this.lockedTimes.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kill() {
        super.kill();
        Object object = this.objectMutex;
        synchronized (object) {
            while (this.latch != null && this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            while (this.lockedTimes != null && this.lockedTimes.size() > 0) {
                try {
                    long time2 = this.lockedTimes.get(0);
                    this.unlockTime(this.lockedTimes.get(0));
                    if (this.lockedTimes.get(0) != time2) continue;
                    this.lockedTimes.remove(0);
                }
                catch (Exception exception) {}
            }
        }
    }
}

