/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection.jmx;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DynamicProxy
implements DynamicMBean {
    protected ObjectName objectName;
    MBeanServerConnection mbsc;

    public DynamicProxy(ObjectName objectName, MBeanServerConnection mbsc) {
        this.objectName = objectName;
        this.mbsc = mbsc;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.mbsc.getAttribute(this.objectName, attribute);
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.mbsc.setAttribute(this.objectName, attribute);
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.mbsc.getAttributes(this.objectName, attributes);
        }
        catch (Exception ex) {
            Logger.getLogger(DynamicProxy.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.mbsc.setAttributes(this.objectName, attributes);
        }
        catch (Exception ex) {
            Logger.getLogger(DynamicProxy.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.mbsc.invoke(this.objectName, actionName, params, signature);
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
    }

    public Object invokeNoException(String actionName, Object[] params, String[] signature) {
        try {
            return this.invoke(actionName, params, signature);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            return this.mbsc.getMBeanInfo(this.objectName);
        }
        catch (InstanceNotFoundException ex) {
            Logger.getLogger(DynamicProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(DynamicProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ReflectionException ex) {
            Logger.getLogger(DynamicProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DynamicProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }
}

