/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.ut2004;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.ILogicWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

@AgentScoped
public abstract class SposhLogicController<BOT extends UT2004Bot, WORK_EXECUTOR extends IWorkExecutor>
extends UT2004BotLogicController<BOT> {
    public static final String SPOSH_LOG_CATEGORY = "SPOSH";
    private List<PoshEngine> engines = new LinkedList<PoshEngine>();
    private WORK_EXECUTOR workExecutor;
    private ITimer timer;

    @Override
    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.createEngines();
    }

    private void createEngines() {
        try {
            int planId = 0;
            for (String planSrc : this.getPlans()) {
                this.engines.add(this.createEngine(planId++, planSrc));
            }
        }
        catch (IOException ex) {
            this.bot.getLogger().getCategory(SPOSH_LOG_CATEGORY).log(Level.SEVERE, "IOException {0} - Stacktrace:\n{1}", new Object[]{ex.getMessage(), this.getStackTrace(ex)});
            throw new IllegalStateException(ex);
        }
    }

    private String getStackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    protected abstract WORK_EXECUTOR createWorkExecutor();

    protected final WORK_EXECUTOR getWorkExecutor() {
        if (this.workExecutor == null) {
            this.workExecutor = this.createWorkExecutor();
        }
        return this.workExecutor;
    }

    @Override
    public final void logic() {
        this.logicBeforePlan();
        for (int engineId = 0; engineId < this.engines.size(); ++engineId) {
            this.iterateEngine(this.engines.get(engineId), engineId);
        }
        this.logicAfterPlan();
    }

    private void iterateEngine(PoshEngine engine, int engineId) {
        engine.getLog().log(Level.INFO, "Invoking Yaposh engine " + engineId + " for plan: " + engine.getName());
        while (true) {
            PoshEngine.EvaluationResultInfo result = engine.evaluatePlan((IWorkExecutor)this.getWorkExecutor());
            if (result.type == null || result.type != FireResult.Type.CONTINUE && result.type != FireResult.Type.FOLLOW && result.type != FireResult.Type.FULFILLED && result.type != FireResult.Type.SURFACE_CONTINUE && result.type != FireResult.Type.FAILED) break;
            engine.getLog().info("Plan evaluation continues...");
        }
        engine.getLog().info("Plan evaluation end.");
    }

    protected void logicBeforePlan() {
        if (this.workExecutor instanceof ILogicWorkExecutor) {
            ILogicWorkExecutor logicExecutor = (ILogicWorkExecutor)this.workExecutor;
            logicExecutor.logicBeforePlan();
        }
    }

    protected void logicAfterPlan() {
        if (this.workExecutor instanceof ILogicWorkExecutor) {
            ILogicWorkExecutor logicExecutor = (ILogicWorkExecutor)this.workExecutor;
            logicExecutor.logicAfterPlan();
        }
    }

    protected ITimer createTimer() {
        return new SystemClockTimer();
    }

    protected final ITimer getTimer() {
        if (this.timer == null) {
            this.timer = this.createTimer();
        }
        return this.timer;
    }

    private PoshPlan parsePlan(String planSource) throws ParseException {
        StringReader planReader = new StringReader(planSource);
        PoshParser parser2 = new PoshParser(planReader);
        return parser2.parsePlan();
    }

    private PoshEngine createEngine(int engineId, String planSrc) {
        try {
            PoshPlan plan = this.parsePlan(planSrc);
            return new PoshEngine(engineId, plan, this.getTimer(), this.bot.getLogger().getCategory(SPOSH_LOG_CATEGORY));
        }
        catch (ParseException ex) {
            this.bot.getLogger().getCategory(SPOSH_LOG_CATEGORY).log(Level.SEVERE, "Parse exceptions during parsing plan:\n{0}\nStacktrace:\n{1}", new Object[]{planSrc, this.getStackTrace(ex)});
            throw new IllegalArgumentException(ex);
        }
    }

    protected final List<PoshEngine> getEngines() {
        return this.engines;
    }

    protected abstract List<String> getPlans() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPlanFromStream(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder plan = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                plan.append(line);
            }
        }
        finally {
            br.close();
        }
        return plan.toString();
    }

    protected final List<String> getPlansFromDirectory(String directoryPath) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : new File(directoryPath).listFiles()) {
            if (!".lap".equals(file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".")))) continue;
            files.add(file);
        }
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            result.add(this.getPlanFromFile(file.getAbsolutePath()));
        }
        return result;
    }

    protected final String getPlanFromFile(String filename) throws IOException {
        FileInputStream f = new FileInputStream(filename);
        return this.getPlanFromStream(f);
    }

    protected final String getPlanFromResource(String resourcePath) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        return this.getPlanFromStream(cl.getResourceAsStream(resourcePath));
    }
}

