/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DriveCollection
extends PoshDummyElement<DriveCollection, PoshPlan>
implements INamedElement {
    private String name;
    private final Trigger<DriveCollection> goal = new Trigger<DriveCollection>(this);
    private final List<DriveElement> elements = new LinkedList<DriveElement>();
    private final List<DriveElement> elementsUm = Collections.unmodifiableList(this.elements);
    public static final String dcName = "dcName";
    public static final DataFlavor dataFlavor = new DataFlavor(DriveCollection.class, "drive-collection-node");

    DriveCollection(String name) {
        assert (name != null && !name.isEmpty());
        this.name = name;
    }

    public void addDrive(DriveElement drive) throws DuplicateNameException {
        int behindLastDriveIndex = this.elementsUm.size();
        this.addDrive(behindLastDriveIndex, drive);
    }

    public void addDrive(int index, DriveElement drive) throws DuplicateNameException {
        assert (!this.elementsUm.contains(drive));
        if (drive.getParent() != null) assert (!((DriveCollection)drive.getParent()).getChildDataNodes().contains(drive));
        if (DriveCollection.isUsedName(drive.getName(), this.elements)) {
            throw new DuplicateNameException("DC " + this.name + " already have drive with name " + drive.getName());
        }
        this.elements.add(index, drive);
        drive.setParent(this);
        this.emitChildNode(drive);
    }

    public Trigger<DriveCollection> getGoal() {
        return this.goal;
    }

    public List<DriveElement> getDrives() {
        return this.elementsUm;
    }

    public DriveElement getDrive(int id) {
        return this.elementsUm.get(id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t(DC ").append(this.name);
        if (!this.goal.isEmpty()) {
            sb.append(" (goal ").append(this.goal.toString()).append(')');
        }
        sb.append('\n');
        sb.append("\t\t(drives \n");
        for (DriveElement element : this.elements) {
            sb.append("\t\t\t  (").append(element.toString()).append(")\n");
        }
        sb.append("\t\t)\n");
        sb.append("\t)");
        return sb.toString();
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>(this.goal);
        children.addAll(this.elementsUm);
        return children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) throws InvalidNameException {
        if (!(newName = newName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw new InvalidNameException("Name " + newName + " is not valid.");
        }
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(dcName, oldName, this.name);
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        assert (child instanceof DriveElement);
        return this.moveChildInList(this.elements, (DriveElement)child, newIndex);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public LapType getType() {
        return LapType.DRIVE_COLLECTION;
    }

    public void removeDrive(DriveElement drive) {
        assert (this.elements.contains(drive));
        if (this.elements.size() == 1) {
            String unusedName = DriveCollection.getUnusedName("drive-", this.elementsUm);
            try {
                this.addDrive(LapElementsFactory.createDriveElement(unusedName));
            }
            catch (DuplicateNameException ex) {
                String msg = "Unused name " + unusedName + " is not unused.";
                Logger.getLogger(DriveCollection.class.getName()).log(Level.SEVERE, msg, ex);
                throw new FubarException(msg, ex);
            }
        }
        int removedDrivePosition = this.elementsUm.indexOf(drive);
        this.elements.remove(drive);
        drive.setParent(null);
        this.emitChildDeleted(drive, removedDrivePosition);
    }
}

