/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.impl;

import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.impl.BatchAwareWorldView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;

public abstract class LockableBatchAwareWorldView
extends BatchAwareWorldView
implements ILockableWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "LockableBatchAwareWorldView";
    private Queue<List<IWorldChangeEvent>> batches = new LinkedList<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new ArrayList<IWorldChangeEvent>();
    private boolean locked = false;
    private boolean beginCame = false;
    private final Object objectMutex = new Object();

    public LockableBatchAwareWorldView(@Named(value="LockableBatchAwareWorldView") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
    }

    @Override
    protected abstract boolean isBatchBeginEvent(IWorldChangeEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.locked = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view locked.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isLocked()) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view is being unlocked.");
            }
            this.locked = false;
            for (List list : this.batches) {
                this.processBatch(list);
            }
            this.batches.clear();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    private void processBatch(List<IWorldChangeEvent> batch) {
        for (IWorldChangeEvent event : batch) {
            super.notify(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IWorldChangeEvent event) {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.beginCame) {
                if (this.isBatchBeginEvent(event)) {
                    this.beginCame = true;
                } else {
                    super.notify(event);
                    return;
                }
            }
            if (this.isLocked()) {
                if (this.isBatchEndEvent(event)) {
                    this.currentBatch.add(event);
                    this.batches.add(this.currentBatch);
                    this.currentBatch = new ArrayList<IWorldChangeEvent>(this.currentBatch.size() + 20);
                } else {
                    this.currentBatch.add(event);
                }
            } else if (this.isBatchEndEvent(event)) {
                this.currentBatch.add(event);
                this.processBatch(this.currentBatch);
                this.currentBatch.clear();
            } else {
                this.currentBatch.add(event);
            }
        }
    }
}

