/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseResult;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

final class SenseListExecutor<T extends PoshElement>
extends AbstractExecutor {
    private List<SenseExecutor> sensesExecutors = new ArrayList<SenseExecutor>();

    SenseListExecutor(Trigger<T> trigger, VariableContext ctx, Logger log) {
        this(ctx, log);
        for (Sense sense : trigger) {
            this.sensesExecutors.add(new SenseExecutor(sense, ctx, log));
        }
    }

    SenseListExecutor(VariableContext ctx, Logger log) {
        super(ctx, log);
    }

    public TriggerResult fire(IWorkExecutor workExecuter, boolean defaultReturn) {
        LinkedList<SenseResult> senses = new LinkedList<SenseResult>();
        for (SenseExecutor senseExecutor : this.sensesExecutors) {
            defaultReturn = true;
            SenseResult res = senseExecutor.fire(workExecuter);
            senses.add(res);
            if (res.wasSuccessful()) continue;
            return new TriggerResult(senses, false);
        }
        return new TriggerResult(senses, defaultReturn);
    }
}

