/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.shady.engine;

import cz.cuni.amis.pogamut.shady.IArgument;
import cz.cuni.amis.pogamut.shady.NodeCall;
import cz.cuni.amis.pogamut.shady.NodeElement;
import cz.cuni.amis.pogamut.shady.ShadeNode;
import cz.cuni.amis.pogamut.shady.ShadeTree;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.exceptions.MissingRootException;
import cz.cuni.amis.pogamut.sposh.exceptions.NoEligibleElementException;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class ShadeEngine<EXECUTOR extends IWorkExecutor> {
    private final ShadeTree plan;
    private final EXECUTOR executor;

    public ShadeEngine(ShadeTree plan, EXECUTOR executor) {
        this.plan = plan;
        this.executor = executor;
    }

    public void evaluate() throws MissingRootException, NoEligibleElementException {
        ShadeNode node = this.plan.getRoot();
        NodeCall call = this.selectCall(node);
    }

    protected NodeCall selectCall(ShadeNode node) throws NoEligibleElementException {
        NodeElement elem = this.getSelectedElement(node);
        NodeCall call = elem.getCall();
        ShadeNode childNode = this.plan.findNode(call.getName());
        if (childNode != null) {
            return this.selectCall(childNode);
        }
        return call;
    }

    protected NodeElement getSelectedElement(ShadeNode node) throws NoEligibleElementException {
        TreeMap elements = new TreeMap(Collections.reverseOrder());
        for (NodeElement elem : node.getElements()) {
            BigDecimal elementPriority = elem.getPriority().execute((IWorkExecutor)this.executor);
            elements.put(elementPriority, elem);
        }
        for (NodeElement elem : elements.values()) {
            BigDecimal triggerResult = elem.getTrigger().execute((IWorkExecutor)this.executor);
            if (BigDecimal.ZERO.equals(triggerResult)) continue;
            return elem;
        }
        throw new NoEligibleElementException("Node \"" + node.getName() + "\" doesn't have even one elegible element.");
    }

    protected BigDecimal executeCall(NodeCall call) {
        Object result;
        VariableContext ctx = new VariableContext();
        List<IArgument> args = call.getArgs();
        for (int argIdx = 0; argIdx < args.size(); ++argIdx) {
            ctx.put(Integer.toString(argIdx), args.get(argIdx).getValue());
        }
        try {
            result = this.executor.executeSense(call.getName(), ctx);
        }
        catch (Exception e) {
            result = this.executor.executeAction(call.getName(), ctx);
        }
        return (BigDecimal)result;
    }
}

