/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.analyzer;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentRunner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.analyzer.IAnalyzerObserverListener;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerFullObserverParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerModule;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004AnalyzerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverFactory;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004AnalyzerRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ObserverRunner;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.listener.Listeners;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class UT2004Analyzer
extends UT2004Server
implements IUT2004Analyzer {
    private Object mutex = new Object();
    private Listeners<IAnalyzerObserverListener> observerListeners = new Listeners();
    private IAnalyzerObserverListener.ObserverAddedNotifier observerAddedNotifier = new IAnalyzerObserverListener.ObserverAddedNotifier();
    private IAnalyzerObserverListener.ObserverRemovedNotifier observerRemovedNotifier = new IAnalyzerObserverListener.ObserverRemovedNotifier();
    private IWorldObjectListener<Player> playerListener = new IWorldObjectListener<Player>(){

        @Override
        public void notify(IWorldObjectEvent<Player> event) {
            Player plr = event.getObject();
            if (plr.getJmx() != null && plr.getJmx().length() > 0) {
                if (event instanceof WorldObjectDestroyedEvent) {
                    UT2004Analyzer.this.removeObserver(plr.getId());
                } else {
                    UT2004Analyzer.this.addObserver(plr.getId(), plr.getName());
                }
            }
        }
    };
    private IWorldEventListener<PlayerJoinsGame> playerJoinsGameListener = new IWorldEventListener<PlayerJoinsGame>(){

        @Override
        public void notify(PlayerJoinsGame event) {
            UT2004Analyzer.this.addObserver(event.getId(), event.getName());
        }
    };
    private IWorldEventListener<PlayerLeft> playerLeftListener = new IWorldEventListener<PlayerLeft>(){

        @Override
        public void notify(PlayerLeft event) {
            UT2004Analyzer.this.removeObserver(event.getId());
        }
    };
    private Map<UnrealId, IUT2004AnalyzerObserver> observers = new HashMap<UnrealId, IUT2004AnalyzerObserver>();
    private UT2004ObserverRunner<IUT2004AnalyzerObserver, UT2004AnalyzerFullObserverParameters> observerRunner;
    private File humanLike_outputFile = null;
    private PrintWriter humanLike_writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObserver(UnrealId botId, String botName) {
        if (!this.inState(IAgentStateRunning.class)) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Not running yet, could not add observer for " + botId + ".");
            }
            return;
        }
        Map<UnrealId, IUT2004AnalyzerObserver> map = this.observers;
        synchronized (map) {
            if (this.observers.containsKey(botId)) {
                return;
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("New bot has connected to the game, creating new observer for the bot with id '" + botId.getStringId() + "'.");
            }
            String fileName = this.getParams().getFileNames() != null ? this.getParams().getFileNames().get(botId) + ".csv" : null;
            IUT2004AnalyzerObserver observer = (IUT2004AnalyzerObserver)this.getObserverRunner().startAgents(new UT2004AnalyzerFullObserverParameters[]{new UT2004AnalyzerFullObserverParameters().setObservedAgentId(botId.getStringId()).setOutputPath(this.getParams().getOutputPath()).setWaitForMatchRestart(this.getParams().isWaitForMatchRestart()).setFileName(fileName).setWorldAddress(this.getParams().getObserverAddress()).setHumanLikeObserving(botName, this.humanLike_writer)}).get(0);
            this.observers.put(botId, observer);
            this.observerAddedNotifier.setBotId(botId);
            this.observerAddedNotifier.setObserver(observer);
            this.observerListeners.notify(this.observerAddedNotifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObserver(UnrealId botId) {
        Map<UnrealId, IUT2004AnalyzerObserver> map = this.observers;
        synchronized (map) {
            IUT2004AnalyzerObserver observer = this.observers.get(botId);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Bot '" + botId.getStringId() + "' has left the game");
            }
            if (observer != null) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Stopping observer for the bot.");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException(e, (Object)this);
                }
                if (observer.getState().getFlag() instanceof IAgentStateUp) {
                    try {
                        observer.stop();
                    }
                    catch (Exception e) {
                        this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be stopped, killing...");
                        try {
                            observer.kill();
                        }
                        catch (Exception e2) {
                            this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be killed: " + e2.getMessage());
                        }
                    }
                }
                this.observers.remove(botId);
                this.observerRemovedNotifier.setBotId(botId);
                this.observerRemovedNotifier.setObserver(observer);
                this.observerListeners.notify(this.observerRemovedNotifier);
            } else if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("The bot '" + botId.getStringId() + "' has no observer attached, was not observer, probably because the analyzer has been started after the bot itself.");
            }
        }
    }

    @Inject
    public UT2004Analyzer(UT2004AnalyzerParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
        this.observerListeners.setLog(this.log, "ObserverListeners");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UT2004ObserverRunner<IUT2004AnalyzerObserver, UT2004AnalyzerFullObserverParameters> getObserverRunner() {
        if (this.observerRunner == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.observerRunner == null) {
                    this.observerRunner = new UT2004ObserverRunner(new UT2004ObserverFactory(this.getParams().getObserverModule()));
                }
            }
        }
        return this.observerRunner;
    }

    @Override
    public UT2004AnalyzerParameters getParams() {
        return (UT2004AnalyzerParameters)super.getParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UnrealId, IUT2004AnalyzerObserver> getObservers() {
        Map<UnrealId, IUT2004AnalyzerObserver> map = this.observers;
        synchronized (map) {
            return new HashMap<UnrealId, IUT2004AnalyzerObserver>(this.observers);
        }
    }

    @Override
    protected void startAgent() {
        super.startAgent();
        if (this.getParams().getHumanLikeObserving() != null && this.getParams().getHumanLikeObserving().booleanValue()) {
            File humanLike_outputFileDir = new File(this.getParams().getOutputPath());
            humanLike_outputFileDir.mkdirs();
            this.humanLike_outputFile = new File(this.getParams().getOutputPath() + System.getProperty("file.separator") + "humanLikeData.log");
            try {
                this.humanLike_writer = new PrintWriter(new FileOutputStream(this.humanLike_outputFile));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not create writer for human-like log at: " + this.humanLike_outputFile.getAbsolutePath());
            }
        }
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerLeft.class, this.playerLeftListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Player.class, this.playerListener);
    }

    @Override
    protected void startPausedAgent() {
        super.startPausedAgent();
        if (this.getParams().getHumanLikeObserving() != null && this.getParams().getHumanLikeObserving().booleanValue()) {
            File humanLike_outputFileDir = new File(this.getParams().getOutputPath());
            humanLike_outputFileDir.mkdirs();
            this.humanLike_outputFile = new File(this.getParams().getOutputPath() + System.getProperty("file.separator") + "humanLikeData.log");
            try {
                this.humanLike_writer = new PrintWriter(new FileOutputStream(this.humanLike_outputFile));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not create writer for human-like log at: " + this.humanLike_outputFile.getAbsolutePath());
            }
        }
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerLeft.class, this.playerLeftListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Player.class, this.playerListener);
    }

    @Override
    protected void stopAgent() {
        super.stopAgent();
        this.cleanUp();
    }

    @Override
    protected void killAgent() {
        super.killAgent();
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        ((UT2004WorldView)this.getWorldView()).removeEventListener(PlayerLeft.class, this.playerLeftListener);
        ((UT2004WorldView)this.getWorldView()).removeObjectListener(Player.class, this.playerListener);
        Map<UnrealId, IUT2004AnalyzerObserver> map = this.observers;
        synchronized (map) {
            for (IUT2004AnalyzerObserver observer : this.observers.values()) {
                if (!(observer.getState().getFlag() instanceof IAgentStateUp)) continue;
                try {
                    observer.stop();
                }
                catch (Exception e) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be stopped, killing...");
                    }
                    try {
                        observer.kill();
                    }
                    catch (Exception e2) {
                        if (!this.log.isLoggable(Level.WARNING)) continue;
                        this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be killed: " + e2.getMessage());
                    }
                }
            }
            if (this.humanLike_writer != null) {
                try {
                    this.humanLike_writer.close();
                }
                catch (Exception e) {
                    if (this.humanLike_outputFile != null) {
                        this.log.warning("Failed to close human-like log file at: " + this.humanLike_outputFile.getAbsolutePath());
                    }
                    this.log.warning("Failed to close human-like log file (unknown location, weird as well...)!");
                }
                this.humanLike_outputFile = null;
                this.humanLike_writer = null;
            }
        }
    }

    public static void main(String[] args) {
        UT2004AnalyzerRunner analyzerRunner = new UT2004AnalyzerRunner(new UT2004AnalyzerFactory(new UT2004AnalyzerModule()));
        analyzerRunner.setLogLevel(Level.INFO);
        ((AgentRunner)analyzerRunner.setMain(true)).startAgent();
    }

    @Override
    public void addListener(IAnalyzerObserverListener listener) {
        this.observerListeners.addWeakListener(listener);
    }

    @Override
    public boolean isListening(IAnalyzerObserverListener listener) {
        return this.observerListeners.isListening(listener);
    }

    @Override
    public void removeListener(IAnalyzerObserverListener listener) {
        this.observerListeners.removeListener(listener);
    }
}

