/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class APExecutor
extends AbstractExecutor
implements ElementExecutor {
    private ActionPattern actionPattern;
    private PoshPlan plan;
    private int index = 0;
    private FireResult.Type result;

    APExecutor(PoshPlan plan, ActionPattern ap, FireResult.Type result, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.result = result;
        this.index = 0;
        this.plan = plan;
        this.actionPattern = ap;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (this.index == this.actionPattern.getActions().size()) {
            return new FireResult(this.result);
        }
        TriggeredAction action = this.actionPattern.getActions().get(this.index);
        StackElement stackElement = this.createActionExecutor(this.plan, action.getActionCall());
        return new FireResult(FireResult.Type.FOLLOW, stackElement);
    }

    private StackElement createActionExecutor(PoshPlan plan, PrimitiveCall actionCall) {
        StackElement element = this.getElement(plan, actionCall, FireResult.Type.SURFACE_CONTINUE, FireResult.Type.SURFACE, FireResult.Type.SURFACE, FireResult.Type.FAILED, new Runnable(){

            @Override
            public void run() {
                ++APExecutor.this.index;
            }
        }, null, new Runnable(){

            @Override
            public void run() {
                ++APExecutor.this.index;
            }
        }, null);
        if (element.getExecutor() instanceof APExecutor) {
            ++this.index;
        }
        return element;
    }

    @Override
    public TriggerResult getTriggerResult() {
        return new TriggerResult(true);
    }
}

