/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class ActionExecutor
extends AbstractExecutor
implements ElementExecutor {
    private final PrimitiveCall actionCall;
    private final FireResult.Type finishedResult;
    private final FireResult.Type runningResult;
    private final FireResult.Type runningOnceResult;
    private final FireResult.Type failedResult;
    private final Runnable finishedResultCallback;
    private final Runnable runningResultCallback;
    private final Runnable runningOnceResultCallback;
    private final Runnable failedResultCallback;

    ActionExecutor(PrimitiveCall actionCall, FireResult.Type finishedResult, FireResult.Type runningResult, FireResult.Type runningOnceResult, FireResult.Type failedResult, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.actionCall = actionCall;
        this.finishedResult = finishedResult;
        this.runningResult = runningResult;
        this.runningOnceResult = runningOnceResult;
        this.failedResult = failedResult;
        this.finishedResultCallback = null;
        this.runningResultCallback = null;
        this.runningOnceResultCallback = null;
        this.failedResultCallback = null;
    }

    ActionExecutor(PrimitiveCall actionCall, FireResult.Type finishedResult, FireResult.Type runningResult, FireResult.Type runningOnceResult, FireResult.Type failedResult, Runnable finishedResultCallback, Runnable runningResultCallback, Runnable runningOnceResultCallback, Runnable failedResultCallback, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.actionCall = actionCall;
        this.finishedResult = finishedResult;
        this.runningResult = runningResult;
        this.runningOnceResult = runningOnceResult;
        this.failedResult = failedResult;
        this.finishedResultCallback = finishedResultCallback;
        this.runningResultCallback = runningResultCallback;
        this.runningOnceResultCallback = runningOnceResultCallback;
        this.failedResultCallback = failedResultCallback;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        ActionResult result = workExecuter.executeAction(this.actionCall.getName(), this.ctx);
        switch (result) {
            case FAILED: {
                if (this.failedResultCallback != null) {
                    this.failedResultCallback.run();
                }
                return new FireResult(this.failedResult);
            }
            case FINISHED: {
                if (this.finishedResultCallback != null) {
                    this.finishedResultCallback.run();
                }
                return new FireResult(this.finishedResult);
            }
            case RUNNING: {
                if (this.runningResultCallback != null) {
                    this.runningResultCallback.run();
                }
                return new FireResult(this.runningResult);
            }
            case RUNNING_ONCE: {
                if (this.runningOnceResultCallback != null) {
                    this.runningOnceResultCallback.run();
                }
                return new FireResult(this.runningResult);
            }
        }
        throw new IllegalStateException("Unexpected ActionResult: " + (Object)((Object)result));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.actionCall.getName() + "]";
    }

    @Override
    public TriggerResult getTriggerResult() {
        return new TriggerResult(true);
    }
}

