/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class LapPath {
    private static char LINK_SEPARATOR = (char)47;
    private static char TYPE_SEPARATOR = (char)58;
    private final Link[] links;

    LapPath() {
        this.links = new Link[0];
    }

    private LapPath(List<Link> links) {
        this.links = links.toArray(new Link[links.size()]);
    }

    private void traverseRoot(Iterator<Link> iter) {
        if (!iter.hasNext()) {
            throw new IllegalStateException("No plan specified in the path.");
        }
        Link rootLink = iter.next();
        if (rootLink.type != LapType.PLAN) {
            throw new IllegalStateException("First link always has type " + (Object)((Object)LapType.PLAN) + ", but is " + (Object)((Object)rootLink.type));
        }
        if (rootLink.id != 0) {
            throw new IndexOutOfBoundsException("Id of plan must be 0, but is " + rootLink.id);
        }
    }

    private void traversePlan(Iterator<Link> iter) {
        Link planLink = iter.next();
        if (planLink.type != LapType.DRIVE_COLLECTION) {
            throw new IllegalStateException("Second link always has type " + (Object)((Object)LapType.DRIVE_COLLECTION) + ", but is " + (Object)((Object)planLink.type));
        }
        if (planLink.id != 0) {
            throw new IndexOutOfBoundsException("Id of drive collection must be 0, but is " + planLink.id);
        }
    }

    private static PoshElement traverseDriveCollection(Iterator<Link> iter, PoshPlan plan) {
        Link driveCollectionLink = iter.next();
        DriveCollection driveCollection = plan.getDriveCollection();
        if (driveCollectionLink.type == LapType.DRIVE_ELEMENT) {
            DriveElement drive = driveCollection.getDrives().get(driveCollectionLink.id);
            if (!iter.hasNext()) {
                return drive;
            }
            return LapPath.traverseDrive(iter, plan, drive);
        }
        if (driveCollectionLink.type == LapType.SENSE) {
            Sense goalSense = driveCollection.getGoal().get(driveCollectionLink.id);
            if (iter.hasNext()) {
                throw new IllegalStateException("Goal sense must be last link, but isn't.");
            }
            return goalSense;
        }
        throw new IllegalStateException("Link was expected to be DRIVE or SENSE, but is " + (Object)((Object)driveCollectionLink.type));
    }

    private static PoshElement traverseDrive(Iterator<Link> iter, PoshPlan plan, DriveElement drive) {
        Link driveLink = iter.next();
        if (driveLink.type == LapType.SENSE) {
            Sense driveTriggerSense = drive.getTrigger().get(driveLink.id);
            if (iter.hasNext()) {
                throw new IllegalStateException("Drive trigger sense must be last link, but isn't.");
            }
            return driveTriggerSense;
        }
        if (driveLink.type == LapType.ACTION) {
            if (driveLink.id != 0) {
                throw new IndexOutOfBoundsException("Id of action in drive should be 0, but is " + driveLink.id);
            }
            TriggeredAction action = drive.getAction();
            if (!iter.hasNext()) {
                return action;
            }
            return LapPath.traverseReference(iter, plan, action);
        }
        throw new IllegalStateException("Link was expected to be SENSE or ACTION, but is " + (Object)((Object)driveLink.type));
    }

    private static PoshElement traverseReference(Iterator<Link> iter, PoshPlan plan, TriggeredAction reference) {
        Link referenceLink = iter.next();
        if (referenceLink.type == LapType.ADOPT) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        if (referenceLink.type == LapType.ACTION_PATTERN) {
            ActionPattern actionPattern = plan.getActionPatterns().get(referenceLink.id);
            if (!reference.getName().equals(actionPattern.getName())) {
                throw new IllegalStateException("Reference link with name " + reference.getName() + " does not match referencing AP " + referenceLink.id + " with name " + actionPattern.getName());
            }
            if (!iter.hasNext()) {
                return actionPattern;
            }
            return LapPath.traverseActionPattern(iter, plan, actionPattern);
        }
        if (referenceLink.type == LapType.COMPETENCE) {
            Competence competence = plan.getCompetences().get(referenceLink.id);
            if (!reference.getName().equals(competence.getName())) {
                throw new IllegalStateException("Reference link with name " + reference.getName() + " does not match referencing C " + referenceLink.id + " with name " + competence.getName());
            }
            if (!iter.hasNext()) {
                return competence;
            }
            return LapPath.traverseCompetence(iter, plan, competence);
        }
        throw new IllegalStateException("Link was expected to be ADOPT, ACTION_PATTERN or COMPETENCE, but is " + (Object)((Object)referenceLink.type));
    }

    private static PoshElement traverseActionPattern(Iterator<Link> iter, PoshPlan plan, ActionPattern actionPattern) {
        Link actionPatternLink = iter.next();
        if (actionPatternLink.type != LapType.ACTION) {
            throw new IllegalStateException("Action pattern can have only action subnodes.");
        }
        TriggeredAction action = actionPattern.getActions().get(actionPatternLink.id);
        if (!iter.hasNext()) {
            return action;
        }
        return LapPath.traverseReference(iter, plan, action);
    }

    private static PoshElement traverseCompetence(Iterator<Link> iter, PoshPlan plan, Competence competence) {
        Link competenceLink = iter.next();
        if (competenceLink.type != LapType.COMPETENCE_ELEMENT) {
            throw new IllegalStateException("Link from competence can be only choice, but is " + (Object)((Object)competenceLink.type));
        }
        CompetenceElement choice = competence.getChildDataNodes().get(competenceLink.id);
        if (!iter.hasNext()) {
            return choice;
        }
        return LapPath.traverseChoice(iter, plan, choice);
    }

    private static PoshElement traverseChoice(Iterator<Link> iter, PoshPlan plan, CompetenceElement choice) {
        Link choiceLink = iter.next();
        if (choiceLink.type == LapType.SENSE) {
            Sense choiceTriggerSense = choice.getTrigger().get(choiceLink.id);
            if (iter.hasNext()) {
                throw new IllegalStateException("Trigger sense of choice is not last link in path.");
            }
            return choiceTriggerSense;
        }
        if (choiceLink.type == LapType.ACTION) {
            if (choiceLink.id != 0) {
                throw new IllegalStateException("Id of action in choice should be 0, but is " + choiceLink.id);
            }
            TriggeredAction action = choice.getAction();
            if (!iter.hasNext()) {
                return action;
            }
            return LapPath.traverseReference(iter, plan, action);
        }
        throw new IllegalStateException("Expecting sense or action in choice, got " + (Object)((Object)choiceLink.type));
    }

    public PoshElement traversePath(PoshPlan plan) {
        Iterator<Link> iterator = Arrays.asList(this.links).iterator();
        this.traverseRoot(iterator);
        if (!iterator.hasNext()) {
            return plan;
        }
        this.traversePlan(iterator);
        if (!iterator.hasNext()) {
            return plan.getDriveCollection();
        }
        return LapPath.traverseDriveCollection(iterator, plan);
    }

    private static String getStringUntil(CharacterIterator iter, char terminator) {
        StringBuilder sb = new StringBuilder();
        char currentChar = iter.current();
        while (currentChar != '\uffff' && currentChar != terminator) {
            sb.append(currentChar);
            currentChar = iter.next();
        }
        return sb.toString();
    }

    private static String getDecimals(CharacterIterator iter) {
        StringBuilder sb = new StringBuilder();
        char currentChar = iter.current();
        while (currentChar >= '0' && currentChar <= '9') {
            sb.append(currentChar);
            currentChar = iter.next();
        }
        return sb.toString();
    }

    private static Link parseLink(CharacterIterator iter) throws ParseException {
        char linkSeparator = iter.current();
        if (linkSeparator == '\uffff' || linkSeparator != LINK_SEPARATOR) {
            throw new ParseException("Expected " + LINK_SEPARATOR + " at " + iter.getIndex());
        }
        iter.next();
        String typeString = LapPath.getStringUntil(iter, TYPE_SEPARATOR);
        LapType linkType = null;
        for (LapType type : LapType.values()) {
            if (!type.getName().equals(typeString)) continue;
            linkType = type;
        }
        if (linkType == null) {
            throw new ParseException("No LapType '" + typeString + "' exists.");
        }
        char typeSeparatorChar = iter.current();
        if (typeSeparatorChar == '\uffff' || typeSeparatorChar != TYPE_SEPARATOR) {
            throw new ParseException("Expected " + TYPE_SEPARATOR + " at " + iter.getIndex());
        }
        iter.next();
        try {
            String idString = LapPath.getDecimals(iter);
            int linkId = Integer.parseInt(idString);
            return new Link(linkType, linkId);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    public static LapPath parse(String serializedPath) throws ParseException {
        StringCharacterIterator iter = new StringCharacterIterator(serializedPath);
        LinkedList<Link> parsedLinks = new LinkedList<Link>();
        do {
            parsedLinks.add(LapPath.parseLink(iter));
        } while (iter.current() != '\uffff');
        return new LapPath(parsedLinks);
    }

    public LapPath append(LapType type, int id) {
        LinkedList<Link> newPathLinks = new LinkedList<Link>(Arrays.asList(this.links));
        newPathLinks.add(new Link(type, id));
        return new LapPath(newPathLinks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Link link : this.links) {
            sb.append(link.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LapPath other = (LapPath)obj;
        return Arrays.deepEquals(this.links, other.links);
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Arrays.deepHashCode(this.links);
        return hash;
    }

    private static class Link {
        private final LapType type;
        private final int id;

        public Link(LapType type, int id) {
            this.type = type;
            this.id = id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(LINK_SEPARATOR);
            sb.append(this.type.getName());
            sb.append(TYPE_SEPARATOR);
            sb.append(this.id);
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            if (this.type != other.type) {
                return false;
            }
            return this.id == other.id;
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + (this.type != null ? this.type.hashCode() : 0);
            hash = 37 * hash + this.id;
            return hash;
        }
    }
}

