/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.SteeringProperties;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLPathFollowingProperties;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

public class PathFollowingProperties
extends SteeringProperties {
    private int repulsiveForce;
    private int distance;
    transient IPathFuture<ILocated> path;
    private Location targetLocation;
    private double regulatingForce;
    private int projection;

    public PathFollowingProperties() {
        super(SteeringType.PATH_FOLLOWING);
        this.repulsiveForce = 200;
        this.distance = 400;
        this.targetLocation = new Location(9440.0, -9500.0, -3446.65);
        this.path = null;
        this.regulatingForce = 50.0;
        this.projection = 5;
    }

    public PathFollowingProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.PATH_FOLLOWING, behaviorType);
        this.repulsiveForce = 200;
        this.distance = 400;
        this.targetLocation = new Location(9440.0, -9500.0, -3446.65);
        this.path = null;
        this.regulatingForce = 50.0;
        this.projection = 5;
        this.setNewBehaviorType(behaviorType);
    }

    public PathFollowingProperties(XMLPathFollowingProperties xml) {
        super(SteeringType.PATH_FOLLOWING, xml.active, xml.weight, xml.behavior);
        this.repulsiveForce = xml.repulsiveForce;
        this.distance = xml.distance;
        this.targetLocation = new Location(xml.xTargetLocation, xml.yTargetLocation, xml.zTargetLocation);
        this.path = null;
        this.regulatingForce = xml.regulatingForce;
        this.projection = xml.projection;
    }

    public PathFollowingProperties(IPathFuture<? extends ILocated> path) {
        super(SteeringType.PATH_FOLLOWING);
        this.repulsiveForce = 200;
        this.distance = 400;
        this.targetLocation = path.getPathTo().getLocation();
        this.path = path;
        this.regulatingForce = 50.0;
        this.projection = 5;
    }

    public PathFollowingProperties(int repulsiveForce, int distanceFromThePath, IPathFuture<ILocated> path, Location targetLocation, double regulatingForce, int projection) {
        super(SteeringType.PATH_FOLLOWING);
        this.repulsiveForce = repulsiveForce;
        this.distance = distanceFromThePath;
        this.path = path;
        this.targetLocation = targetLocation;
        this.regulatingForce = regulatingForce;
        this.projection = projection;
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            this.regulatingForce = 0.0;
            this.projection = 5;
        } else if (behaviorType.equals((Object)SteeringProperties.BehaviorType.ADVANCED)) {
            this.regulatingForce = 50.0;
            this.projection = 5;
        }
    }

    public int getRepulsiveForce() {
        return this.repulsiveForce;
    }

    public void setRepulsiveForce(int orderOfTheForce) {
        this.repulsiveForce = orderOfTheForce;
    }

    public int getDistanceFromThePath() {
        return this.distance;
    }

    public void setDistanceFromThePath(int distanceFromThePath) {
        this.distance = distanceFromThePath;
    }

    public IPathFuture<ILocated> getPath() {
        return this.path;
    }

    public void setPath(IPathFuture<ILocated> path) {
        this.path = path;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    public double getRegulatingForce() {
        return this.regulatingForce;
    }

    public void setRegulatingForce(double regulatingForce) {
        this.regulatingForce = regulatingForce;
    }

    public int getProjection() {
        return this.projection;
    }

    public void setProjection(int projection) {
        this.projection = projection;
    }

    @Override
    public String getSpecialText() {
        String text = "";
        text = text + "  * Repulsive Force: " + this.repulsiveForce + "\n";
        text = text + "  * Target Location: " + this.targetLocation.toString() + "\n";
        text = text + "  * Distance: " + this.distance + "\n";
        text = text + "  * Regulation: " + this.regulatingForce + "\n";
        text = text + "  * Projection: " + this.projection + "\n";
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.repulsiveForce = ((PathFollowingProperties)newProperties).getRepulsiveForce();
        this.distance = ((PathFollowingProperties)newProperties).getDistanceFromThePath();
        this.targetLocation = ((PathFollowingProperties)newProperties).getTargetLocation();
        this.path = ((PathFollowingProperties)newProperties).getPath();
        this.regulatingForce = ((PathFollowingProperties)newProperties).getRegulatingForce();
        this.projection = ((PathFollowingProperties)newProperties).getProjection();
    }

    public XMLPathFollowingProperties getXMLProperties() {
        XMLPathFollowingProperties xmlProp = new XMLPathFollowingProperties();
        xmlProp.repulsiveForce = this.repulsiveForce;
        xmlProp.distance = this.distance;
        xmlProp.xTargetLocation = (int)this.targetLocation.x;
        xmlProp.yTargetLocation = (int)this.targetLocation.y;
        xmlProp.zTargetLocation = (int)this.targetLocation.z;
        xmlProp.regulatingForce = this.regulatingForce;
        xmlProp.projection = this.projection;
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }
}

