/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.translators;

import eis.eis2java.exception.NoTranslatorException;
import eis.eis2java.exception.TranslationException;
import eis.eis2java.translation.Parameter2Java;
import eis.eis2java.translation.Translator;
import eis.iilang.Function;
import eis.iilang.Identifier;
import eis.iilang.Numeral;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import nl.tudelft.goal.unreal.messages.Configuration;
import nl.tudelft.goal.unreal.messages.MapOfParameters;
import nl.tudelft.goal.unreal.translators.BotParametersKeyTranslator;
import nl.tudelft.goal.unreal.translators.BotParametersListTranslator;
import nl.tudelft.goal.unreal.translators.BotParametersTranslator;
import nl.tudelft.goal.unreal.translators.ConfigurationKeyTranslator;
import nl.tudelft.goal.unreal.translators.ConfigurationTranslator;
import nl.tudelft.goal.unreal.translators.LevelTranslator;
import nl.tudelft.goal.unreal.translators.LocationTranslator;
import nl.tudelft.goal.unreal.translators.ParameterMapTranslator;
import nl.tudelft.goal.unreal.translators.RotationTranslator;
import nl.tudelft.goal.unreal.translators.SkinTranslator;
import nl.tudelft.goal.unreal.translators.TeamTranslator;
import nl.tudelft.goal.unreal.translators.URITranslator;
import nl.tudelft.goal.unreal.translators.UnrealIdTranslator;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigurationTranslatorTest {
    @BeforeClass
    public static void setUp() throws Exception {
        Translator translator = Translator.getInstance();
        translator.registerParameter2JavaTranslator((Parameter2Java)new BotParametersKeyTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new BotParametersListTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new BotParametersTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new ConfigurationKeyTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new ConfigurationTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new LevelTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new LocationTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new ParameterMapTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new RotationTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new SkinTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new TeamTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new UnrealIdTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new URITranslator());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() throws NoTranslatorException, TranslationException, URISyntaxException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("visualizer", new Identifier("rmi://127.0.0.1:1099"));
        map.put("botServer", new Identifier("ut://127.0.0.1:3000"));
        map.put("controlServer", new Identifier("ut://127.0.0.1:3001"));
        map.put("logLevel", new Identifier("WARNING"));
        map.put("bots", new ParameterList(new Parameter[]{new ParameterList(new Parameter[]{new ParameterList(new Parameter[]{new Identifier("name"), new Identifier("RedLeader")}), new ParameterList(new Parameter[]{new Identifier("team"), new Identifier("red")}), new ParameterList(new Parameter[]{new Identifier("skill"), new Numeral((Number)5)}), new ParameterList(new Parameter[]{new Identifier("startLocation"), new Function("location", new Parameter[]{new Numeral((Number)1), new Numeral((Number)1), new Numeral((Number)1)})}), new ParameterList(new Parameter[]{new Identifier("startRotation"), new Function("rotation", new Parameter[]{new Numeral((Number)1), new Numeral((Number)1), new Numeral((Number)1)})}), new ParameterList(new Parameter[]{new Identifier("logLevel"), new Identifier("OFF")})}), new ParameterList(new Parameter[]{new ParameterList(new Parameter[]{new Identifier("name"), new Identifier("RedFive")}), new ParameterList(new Parameter[]{new Identifier("team"), new Identifier("red")}), new ParameterList(new Parameter[]{new Identifier("skill"), new Numeral((Number)5)}), new ParameterList(new Parameter[]{new Identifier("startLocation"), new Function("location", new Parameter[]{new Numeral((Number)1), new Numeral((Number)1), new Numeral((Number)1)})}), new ParameterList(new Parameter[]{new Identifier("startRotation"), new Function("rotation", new Parameter[]{new Numeral((Number)1), new Numeral((Number)1), new Numeral((Number)1)})}), new ParameterList(new Parameter[]{new Identifier("logLevel"), new Identifier("OFF")})})}));
        MapOfParameters parameter = new MapOfParameters(map);
        Configuration configuration = (Configuration)Translator.getInstance().translate2Java((Parameter)parameter, Configuration.class);
        Assert.assertEquals((Object)new URI("rmi://127.0.0.1:1099"), (Object)configuration.getVisualizer());
        Assert.assertEquals((Object)new URI("ut://127.0.0.1:3000"), (Object)configuration.getBotServer());
        Assert.assertEquals((Object)new URI("ut://127.0.0.1:3001"), (Object)configuration.getControlServer());
        Assert.assertEquals((Object)Level.WARNING, (Object)configuration.getLogLevel());
    }
}

