/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InplaceEditorAction<C extends JComponent>
extends WidgetAction.LockedAdapter
implements InplaceEditorProvider.TypedEditorController {
    private InplaceEditorProvider<C> provider;
    private C editor = null;
    private Widget widget = null;
    private Rectangle rectangle = null;
    private InplaceEditorProvider.EditorInvocationType invocationType;

    public InplaceEditorAction(InplaceEditorProvider<C> inplaceEditorProvider) {
        this.provider = inplaceEditorProvider;
    }

    @Override
    protected boolean isLocked() {
        return this.editor != null;
    }

    @Override
    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 2 && this.openEditor(widget, InplaceEditorProvider.EditorInvocationType.MOUSE)) {
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.editor != null) {
            Container container = ((Component)this.editor).getParent();
            if (container != null) {
                container.requestFocusInWindow();
            }
            this.closeEditor(true);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.editor != null) {
            Container container = ((Component)this.editor).getParent();
            if (container != null) {
                container.requestFocusInWindow();
            }
            this.closeEditor(true);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        if (widgetKeyEvent.getKeyChar() == '\n' && this.openEditor(widget, InplaceEditorProvider.EditorInvocationType.KEY)) {
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public final boolean isEditorVisible() {
        return this.editor != null;
    }

    @Override
    public final boolean openEditor(Widget widget) {
        return this.openEditor(widget, InplaceEditorProvider.EditorInvocationType.CODE);
    }

    private boolean openEditor(Widget widget, InplaceEditorProvider.EditorInvocationType editorInvocationType) {
        if (this.editor != null) {
            return false;
        }
        Scene scene = widget.getScene();
        JComponent jComponent = scene.getView();
        if (jComponent == null) {
            return false;
        }
        this.invocationType = editorInvocationType;
        this.editor = this.provider.createEditorComponent(this, widget);
        if (this.editor == null) {
            this.invocationType = null;
            return false;
        }
        this.widget = widget;
        jComponent.add((Component)this.editor);
        this.provider.notifyOpened(this, widget, this.editor);
        Rectangle rectangle = widget.getScene().convertSceneToView(widget.convertLocalToScene(widget.getBounds()));
        Point point = GeomUtil.center(rectangle);
        Dimension dimension = ((JComponent)this.editor).getMinimumSize();
        if (rectangle.width > dimension.width) {
            dimension.width = rectangle.width;
        }
        if (rectangle.height > dimension.height) {
            dimension.height = rectangle.height;
        }
        int n = point.x - dimension.width / 2;
        int n2 = point.y - dimension.height / 2;
        rectangle = new Rectangle(n, n2, dimension.width, dimension.height);
        this.updateRectangleToFitToView(rectangle);
        Rectangle rectangle2 = this.provider.getInitialEditorComponentBounds(this, widget, this.editor, rectangle);
        this.rectangle = rectangle2 != null ? rectangle2 : rectangle;
        ((Component)this.editor).setBounds(n, n2, dimension.width, dimension.height);
        this.notifyEditorComponentBoundsChanged();
        ((JComponent)this.editor).requestFocusInWindow();
        return true;
    }

    private void updateRectangleToFitToView(Rectangle rectangle) {
        JComponent jComponent = this.widget.getScene().getView();
        if (rectangle.x + rectangle.width > jComponent.getWidth()) {
            rectangle.x = jComponent.getWidth() - rectangle.width;
        }
        if (rectangle.y + rectangle.height > jComponent.getHeight()) {
            rectangle.y = jComponent.getHeight() - rectangle.height;
        }
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
    }

    @Override
    public final void closeEditor(boolean bl) {
        if (this.editor == null) {
            return;
        }
        Container container = ((Component)this.editor).getParent();
        Rectangle rectangle = container != null ? ((Component)this.editor).getBounds() : null;
        this.provider.notifyClosing(this, this.widget, this.editor, bl);
        if (rectangle != null) {
            container.remove((Component)this.editor);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (container != null) {
            container.requestFocusInWindow();
        }
        this.editor = null;
        this.widget = null;
        this.rectangle = null;
        this.invocationType = null;
    }

    @Override
    public void notifyEditorComponentBoundsChanged() {
        EnumSet<InplaceEditorProvider.ExpansionDirection> enumSet = this.provider.getExpansionDirections(this, this.widget, this.editor);
        if (enumSet == null) {
            enumSet = EnumSet.noneOf(InplaceEditorProvider.ExpansionDirection.class);
        }
        Rectangle rectangle = this.rectangle;
        Dimension dimension = ((JComponent)this.editor).getPreferredSize();
        Dimension dimension2 = ((JComponent)this.editor).getMinimumSize();
        if (dimension2 != null) {
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
        }
        int n = rectangle.height - dimension.height;
        int n2 = rectangle.width - dimension.width;
        boolean bl = enumSet.contains((Object)InplaceEditorProvider.ExpansionDirection.TOP);
        boolean bl2 = enumSet.contains((Object)InplaceEditorProvider.ExpansionDirection.BOTTOM);
        if (bl) {
            if (bl2) {
                rectangle.y += n / 2;
                rectangle.height = dimension.height;
            } else {
                rectangle.y += n;
                rectangle.height = dimension.height;
            }
        } else if (bl2) {
            rectangle.height = dimension.height;
        }
        boolean bl3 = enumSet.contains((Object)InplaceEditorProvider.ExpansionDirection.LEFT);
        boolean bl4 = enumSet.contains((Object)InplaceEditorProvider.ExpansionDirection.RIGHT);
        if (bl3) {
            if (bl4) {
                rectangle.x += n2 / 2;
                rectangle.width = dimension.width;
            } else {
                rectangle.x += n2;
                rectangle.width = dimension.width;
            }
        } else if (bl4) {
            rectangle.width = dimension.width;
        }
        this.updateRectangleToFitToView(rectangle);
        ((Component)this.editor).setBounds(rectangle);
        ((Component)this.editor).repaint();
    }

    @Override
    public InplaceEditorProvider.EditorInvocationType getEditorInvocationType() {
        return this.invocationType;
    }
}

