/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.EIS2Java.handlers;

import eis.exceptions.ActException;
import eis.exceptions.EntityException;
import eis.iilang.Action;
import eis.iilang.Parameter;
import eis.iilang.Percept;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.handlers.ActionHandler;
import nl.tudelft.goal.EIS2Java.handlers.AsynchronousEntity;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import nl.tudelft.goal.EIS2Java.util.EIS2JavaUtil;

public class SynchronizedActionHandler
extends ActionHandler {
    protected final Map<String, Method> actionMethods;
    protected final AsynchronousEntity entity;

    public SynchronizedActionHandler(AsynchronousEntity entity) throws EntityException {
        this.entity = entity;
        this.actionMethods = EIS2JavaUtil.processActionAnnotations(entity.getClass());
    }

    @Override
    public final boolean isSupportedByEntity(Action action) {
        String actionName = EIS2JavaUtil.getNameOfAction(action);
        return this.actionMethods.get(actionName) != null;
    }

    @Override
    public final Percept performAction(Action action) throws ActException {
        String actionName = EIS2JavaUtil.getNameOfAction(action);
        Method actionMethod = this.actionMethods.get(actionName);
        if (actionMethod == null) {
            throw new ActException(7, "Entity does not support action: " + action);
        }
        try {
            return this.performAction(this.entity, actionMethod, action.getName(), action.getParameters());
        }
        catch (Exception e) {
            if (e instanceof ActException) {
                throw (ActException)e;
            }
            throw new ActException(7, "execution of action " + action + "failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Percept performAction(AsynchronousEntity entity, Method method, String actionName, LinkedList<Parameter> parameters) throws ActException {
        Object returnValue;
        Translator translator = Translator.getInstance();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] arguments = new Object[parameters.size()];
        int i = 0;
        for (Parameter parameter : parameters) {
            try {
                arguments[i] = translator.translate2Java(parameter, parameterTypes[i]);
            }
            catch (TranslationException e) {
                throw new ActException(7, "Action " + actionName + " with parameters " + parameters + " failed to be translated", (Exception)e);
            }
            ++i;
        }
        try {
            entity.acquire();
            try {
                returnValue = method.invoke((Object)entity, arguments);
            }
            finally {
                entity.release();
            }
        }
        catch (IllegalArgumentException e) {
            throw new ActException(7, "Action " + actionName + " with parameters " + parameters + " failed to execute", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new ActException(7, "Action " + actionName + " with parameters " + parameters + " failed to execute", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new ActException(7, "Action " + actionName + " with parameters " + parameters + " failed to execute", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new ActException(7, "Action " + actionName + " with parameters " + parameters + " failed to execute. Interupted while aquiring the entity.", (Exception)e);
        }
        if (returnValue == null) {
            return null;
        }
        try {
            return new Percept(actionName, translator.translate2Parameter(returnValue));
        }
        catch (TranslationException e) {
            throw new ActException(7, "Action " + actionName + " with parameters " + parameters + " failed to return a proper failue", (Exception)e);
        }
    }
}

