/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Assign;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;

public class SaxonAssign
extends XSLGeneralVariable {
    private Assign instruction = new Assign();

    public boolean isInstruction() {
        return true;
    }

    public boolean isAssignable() {
        return true;
    }

    protected boolean allowsAsAttribute() {
        return false;
    }

    public void validate() throws XPathException {
        XSLVariableDeclaration declaration;
        super.validate();
        try {
            declaration = this.bindVariable(this.getVariableQName());
            declaration.registerReference(this.instruction);
            this.requiredType = declaration.getRequiredType();
        }
        catch (XPathException err) {
            this.compileError(err.getMessage());
            return;
        }
        if (!declaration.isAssignable()) {
            this.compileError("Variable " + this.getVariableDisplayName() + " is not marked as assignable");
        }
        if (!declaration.isGlobal()) {
            this.compileError("saxon:assign now works only with global variables");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        this.initializeInstruction(exec, this.instruction);
        return this.instruction;
    }
}

