/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeWeapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Thrown;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WeaponUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.AmmoDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class Weaponry
extends SensomotoricModule<UT2004Bot> {
    private Ammunition ammo = new Ammunition();
    WeaponsByKey<ItemType.Group> weaponsByGroup = new WeaponsByKey();
    WeaponsByKey<ItemType> weaponsByItemType = new WeaponsByKey();
    WeaponsByKey<UnrealId> weaponsById = new WeaponsByKey();
    private Map<ItemType, UnrealId> weaponTypeToInventoryUnrealId = new HashMap<ItemType, UnrealId>();
    private Map<UnrealId, WeaponDescriptor> inventoryUnrealIdToWeaponDescriptor = new HashMap<UnrealId, WeaponDescriptor>();
    AddInventoryMsgListener addInventoryMsgListener;
    ItemPickedUpListener itemPickedUpListener;
    WeaponUpdateListener weaponUpdateListener;
    SelfUpdateListener selfUpdateListener;
    ThrownListener thrownListener;
    BotKilledListener botKilledListener;
    private ItemDescriptors itemDescriptors;
    private Self self = null;

    public WeaponDescriptor getDescriptorForId(UnrealId inventoryWeaponId) {
        WeaponDescriptor desc = this.inventoryUnrealIdToWeaponDescriptor.get(inventoryWeaponId);
        if (desc == null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("getDescriptorForId(): There is no WeaponDescriptor for the inventory weapon id '" + inventoryWeaponId.getStringId() + "'.");
        }
        return desc;
    }

    public ItemType getItemTypeForId(UnrealId inventoryWeaponId) {
        WeaponDescriptor desc = this.inventoryUnrealIdToWeaponDescriptor.get(inventoryWeaponId);
        if (desc == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("getItemTypeForId(): There is no WeaponDescriptor for the inventory weapon id '" + inventoryWeaponId.getStringId() + "'.");
            }
            return null;
        }
        return desc.getPickupType();
    }

    public UnrealId getWeaponInventoryId(ItemType weaponType) {
        return this.weaponTypeToInventoryUnrealId.get(weaponType);
    }

    public UnrealId getWeaponInventoryId(WeaponDescriptor weaponDescriptor) {
        if (weaponDescriptor == null) {
            return null;
        }
        if (weaponDescriptor.getPickupType() == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("getWeaponInventoryId(): WeaponDescriptor does not have PickupType assigned!");
            }
            return null;
        }
        return this.weaponTypeToInventoryUnrealId.get(weaponDescriptor.getPickupType());
    }

    public boolean changeWeapon(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        Weapon weapon = this.getWeapon(weaponType);
        return this.changeWeapon(this.getWeapon(weaponType));
    }

    public boolean changeWeapon(Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        if (weapon == this.getCurrentWeapon()) {
            return true;
        }
        if (weapon.getAmmo() <= 0) {
            return false;
        }
        if (((WeaponsByKey)this.weaponsByItemType).all.get(weapon.getType()) == null) {
            return false;
        }
        this.act.act(new ChangeWeapon().setId(weapon.getInventoryId().getStringId()));
        return true;
    }

    public int getAmmo(ItemType ammoOrWeaponType) {
        if (ammoOrWeaponType == null) {
            return 0;
        }
        if (ammoOrWeaponType.getCategory() == ItemType.Category.WEAPON) {
            if (this.hasSecondaryAmmoType(ammoOrWeaponType)) {
                return this.getPrimaryWeaponAmmo(ammoOrWeaponType) + this.getSecondaryWeaponAmmo(ammoOrWeaponType);
            }
            return this.getPrimaryWeaponAmmo(ammoOrWeaponType);
        }
        if (ammoOrWeaponType.getCategory() == ItemType.Category.AMMO) {
            return this.ammo.getAmmo(ammoOrWeaponType);
        }
        return 0;
    }

    public int getPrimaryWeaponAmmo(ItemType weaponType) {
        if (weaponType == null) {
            return 0;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return 0;
        }
        return this.ammo.getPriAmmoForWeapon(weaponType);
    }

    public int getSecondaryWeaponAmmo(ItemType weaponType) {
        if (weaponType == null) {
            return 0;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return 0;
        }
        return this.ammo.getSecAmmoForWeapon(weaponType);
    }

    public int getWeaponAmmo(ItemType weaponType) {
        if (weaponType == null) {
            return 0;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return 0;
        }
        return this.ammo.getAmmoForWeapon(weaponType);
    }

    public boolean hasLowAmmoForWeapon(ItemType weaponType, double lowRatio) {
        return this.hasPrimaryLowAmmoForWeapon(weaponType, lowRatio) || this.hasSecondaryLowAmmoForWeapon(weaponType, lowRatio);
    }

    public boolean hasSecondaryLowAmmoForWeapon(ItemType weaponType, double lowRatio) {
        WeaponDescriptor desc;
        int ammo = this.getSecondaryWeaponAmmo(weaponType);
        return (double)(ammo / (desc = this.getWeaponDescriptor(weaponType)).getPriMaxAmount()) < lowRatio;
    }

    public boolean hasPrimaryLowAmmoForWeapon(ItemType weaponType, double lowRatio) {
        WeaponDescriptor desc;
        if (!this.hasSecondaryAmmoType(weaponType)) {
            return false;
        }
        int ammo = this.getSecondaryWeaponAmmo(weaponType);
        return (double)(ammo / (desc = this.getWeaponDescriptor(weaponType)).getSecMaxAmount()) < lowRatio;
    }

    public boolean hasAmmo(ItemType ammoType) {
        if (ammoType == null) {
            return false;
        }
        if (ammoType.getCategory() != ItemType.Category.AMMO) {
            return false;
        }
        return this.ammo.getAmmo(ammoType) > 0;
    }

    public boolean hasAmmoForWeapon(ItemType weaponType) {
        return this.hasWeaponAmmo(weaponType);
    }

    public boolean hasWeaponAmmo(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        return this.ammo.getAmmoForWeapon(weaponType) > 0;
    }

    public boolean hasPrimaryWeaponAmmo(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        return this.ammo.getPriAmmoForWeapon(weaponType) > 0;
    }

    public boolean hasSecondaryWeaponAmmo(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        return this.ammo.getSecAmmoForWeapon(weaponType) > 0;
    }

    public boolean hasWeapon(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByItemType).all.containsKey(weaponType);
    }

    public boolean hasWeapon(ItemType.Group weaponGroup) {
        if (weaponGroup == null) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByGroup).all.containsKey((Object)weaponGroup);
    }

    public boolean isLoaded(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByItemType).allLoaded.containsKey(weaponType);
    }

    public boolean isLoaded(ItemType.Group weaponGroup) {
        if (weaponGroup == null) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByGroup).allLoaded.containsKey((Object)weaponGroup);
    }

    public boolean hasSecondaryAmmoType(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return false;
        }
        WeaponDescriptor desc = (WeaponDescriptor)this.itemDescriptors.getDescriptor(weaponType);
        if (desc == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("hasSecondaryAmmoType(): There is no weapon descriptor for the item type " + weaponType + "!");
            }
            return false;
        }
        return desc.getSecAmmoItemType() != null && desc.getPriAmmoItemType() != desc.getSecAmmoItemType();
    }

    public WeaponDescriptor getWeaponDescriptor(ItemType weaponType) {
        if (weaponType == null) {
            return null;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return null;
        }
        WeaponDescriptor desc = (WeaponDescriptor)this.itemDescriptors.getDescriptor(weaponType);
        if (desc == null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("getWeaponDescriptor(): There is no weapon descriptor for the item type " + weaponType + "!");
        }
        return desc;
    }

    public Weapon getCurrentWeapon() {
        if (this.self == null) {
            return null;
        }
        if (this.self.getWeapon() == null) {
            return null;
        }
        WeaponDescriptor desc = this.inventoryUnrealIdToWeaponDescriptor.get(UnrealId.get(this.self.getWeapon()));
        if (desc == null) {
            if (this.self.getWeapon().equalsIgnoreCase("None")) {
                return null;
            }
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("getCurrentWeapon(): There is no weapon descriptor for current bot's weapon of id: '" + this.self.getWeapon() + "'");
            }
            return null;
        }
        return (Weapon)((WeaponsByKey)this.weaponsByItemType).all.get(desc.getPickupType());
    }

    public int getCurrentAmmo() {
        if (this.getCurrentWeapon() == null) {
            return 0;
        }
        if (this.getCurrentWeapon().hasSecondaryAmmoType()) {
            return this.getCurrentPrimaryAmmo() + this.getCurrentAlternateAmmo();
        }
        return this.getCurrentPrimaryAmmo();
    }

    public int getCurrentPrimaryAmmo() {
        if (this.self == null) {
            return 0;
        }
        return this.self.getPrimaryAmmo();
    }

    public int getCurrentAlternateAmmo() {
        if (this.self == null) {
            return 0;
        }
        if (this.self.getWeapon() == null) {
            return 0;
        }
        WeaponDescriptor weaponDesc = this.inventoryUnrealIdToWeaponDescriptor.get(UnrealId.get(this.self.getWeapon()));
        if (weaponDesc == null) {
            if (this.self.getWeapon().equals("None")) {
                return 0;
            }
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("getCurrentAlternateAmmo(): There is no weapon descriptor for current bot's weapon of id: '" + this.self.getWeapon() + "'");
            }
            return 0;
        }
        if (weaponDesc.getSecAmmoItemType() != null) {
            return this.self.getSecondaryAmmo();
        }
        return this.self.getPrimaryAmmo();
    }

    public Map<ItemType, Weapon> getWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByItemType).all);
    }

    public Weapon getWeapon(ItemType weaponType) {
        if (weaponType == null) {
            return null;
        }
        if (weaponType.getCategory() != ItemType.Category.WEAPON) {
            return null;
        }
        return (Weapon)((WeaponsByKey)this.weaponsByItemType).all.get(weaponType);
    }

    public Map<ItemType, Weapon> getLoadedWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByItemType).allLoaded);
    }

    public Map<ItemType, Weapon> getMeleeWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByItemType).allMelee);
    }

    public Map<ItemType, Weapon> getRangedWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByItemType).allRanged);
    }

    public Map<ItemType, Weapon> getLoadedMeleeWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByItemType).allLoadedMelee);
    }

    public Map<ItemType, Weapon> getLoadedRangedWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByItemType).allLoadedRanged);
    }

    public Map<ItemType, Integer> getAmmos() {
        return Collections.unmodifiableMap(this.ammo.ammo);
    }

    public boolean hasLoadedWeapon() {
        return !this.getLoadedWeapons().isEmpty();
    }

    public boolean hasLoadedRangedWeapon() {
        return !this.getLoadedRangedWeapons().isEmpty();
    }

    public boolean hasLoadedMeleeWeapon() {
        return !this.getLoadedMeleeWeapons().isEmpty();
    }

    public boolean hasLoadedWeapon(ItemType weapon) {
        return this.hasPrimaryLoadedWeapon(weapon) || this.hasSecondaryLoadedWeapon(weapon);
    }

    public boolean hasPrimaryLoadedWeapon(ItemType weapon) {
        Weapon w = this.getWeapon(weapon);
        if (w == null) {
            return false;
        }
        return w.getPrimaryAmmo() > 0;
    }

    public boolean hasSecondaryLoadedWeapon(ItemType weapon) {
        Weapon w = this.getWeapon(weapon);
        if (w == null) {
            return false;
        }
        return w.getSecondaryAmmo() > 0;
    }

    public ItemType getWeaponForAmmo(ItemType priOrSecAmmoType) {
        for (ItemType weaponType : ItemType.Category.WEAPON.getTypes()) {
            WeaponDescriptor desc = (WeaponDescriptor)this.itemDescriptors.getDescriptor(weaponType);
            if (desc == null) continue;
            if (desc.getPriAmmoItemType() == priOrSecAmmoType) {
                return weaponType;
            }
            if (desc.getSecAmmoItemType() != priOrSecAmmoType) continue;
            return weaponType;
        }
        return null;
    }

    public ItemType getPrimaryWeaponAmmoType(ItemType weaponType) {
        WeaponDescriptor desc = (WeaponDescriptor)this.itemDescriptors.getDescriptor(weaponType);
        if (desc == null) {
            return null;
        }
        return desc.getPriAmmoItemType();
    }

    public ItemType getSecondaryWeaponAmmoType(ItemType weaponType) {
        WeaponDescriptor desc = (WeaponDescriptor)this.itemDescriptors.getDescriptor(weaponType);
        if (desc == null) {
            return null;
        }
        return desc.getSecAmmoItemType();
    }

    public Weaponry(UT2004Bot bot) {
        this(bot, new ItemDescriptors(bot));
    }

    public Weaponry(UT2004Bot bot, ItemDescriptors itemDescriptors) {
        this(bot, itemDescriptors, null);
    }

    public Weaponry(UT2004Bot bot, ItemDescriptors descriptors, LogCategory moduleLog) {
        super(bot);
        this.itemDescriptors = descriptors;
        if (this.itemDescriptors == null) {
            this.itemDescriptors = new ItemDescriptors(bot, moduleLog);
        }
        this.addInventoryMsgListener = new AddInventoryMsgListener(this.worldView);
        this.itemPickedUpListener = new ItemPickedUpListener(this.worldView);
        this.weaponUpdateListener = new WeaponUpdateListener(this.worldView);
        this.selfUpdateListener = new SelfUpdateListener(this.worldView);
        this.thrownListener = new ThrownListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.cleanUp();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.ammo.botKilled();
        this.weaponsByGroup.botKilled();
        this.weaponsByItemType.botKilled();
        this.weaponsById.botKilled();
        this.weaponTypeToInventoryUnrealId.clear();
        this.inventoryUnrealIdToWeaponDescriptor.clear();
    }

    public int getMaxAmmo(ItemType ammoType) {
        if (ammoType == null) {
            return 0;
        }
        WeaponDescriptor weapon = this.getWeaponDescriptor(this.getWeaponForAmmo(ammoType));
        if (weapon == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("There is no known weapon descriptor for item type " + ammoType + " inside Weaponary.");
            }
            return 0;
        }
        if (weapon.getPriAmmoItemType() == ammoType) {
            return weapon.getPriMaxAmount();
        }
        if (weapon.getSecAmmoItemType() == ammoType) {
            return weapon.getSecMaxAmount();
        }
        return 0;
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        @Override
        public void notify(BotKilled event) {
            Weaponry.this.ammo.botKilled();
            Weaponry.this.weaponsByGroup.botKilled();
            Weaponry.this.weaponsByItemType.botKilled();
            Weaponry.this.weaponsById.botKilled();
            Weaponry.this.weaponTypeToInventoryUnrealId.clear();
            Weaponry.this.inventoryUnrealIdToWeaponDescriptor.clear();
        }

        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, this);
        }
    }

    private class ThrownListener
    implements IWorldEventListener<Thrown> {
        @Override
        public void notify(Thrown event) {
            WeaponDescriptor desc = (WeaponDescriptor)Weaponry.this.inventoryUnrealIdToWeaponDescriptor.get(event.getId());
            if (desc == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("ThrownListener.notify(): There is no known weapon descriptor for id " + event.getId() + " inside Weaponary.");
                }
                return;
            }
            ItemType weaponType = desc.getPickupType();
            Weaponry.this.weaponsByGroup.remove(weaponType.getGroup());
            Weaponry.this.weaponsByItemType.remove(weaponType);
        }

        public ThrownListener(IWorldView worldView) {
            worldView.addEventListener(Thrown.class, this);
        }
    }

    private class SelfUpdateListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        @Override
        public void notify(WorldObjectUpdatedEvent<Self> event) {
            Weapon weaponToUpdate;
            if (event == null) {
                return;
            }
            if (Weaponry.this.self == null) {
                Weaponry.this.self = (Self)event.getObject();
            }
            if ((weaponToUpdate = Weaponry.this.getCurrentWeapon()) != null) {
                WeaponDescriptor weaponDesc = weaponToUpdate.getDescriptor();
                if (weaponDesc == null) {
                    if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                        Weaponry.this.log.warning("SelfUpdateListener.notify(): There is no weapon descriptor for the weapon " + weaponToUpdate);
                    }
                    return;
                }
                if (weaponDesc.getPriAmmoItemType() != null) {
                    Weaponry.this.ammo.weaponUpdate(weaponDesc.getPriAmmoItemType(), Weaponry.this.self.getPrimaryAmmo());
                }
                if (weaponDesc.getSecAmmoItemType() != null && weaponDesc.getSecAmmoItemType() != weaponDesc.getPriAmmoItemType()) {
                    Weaponry.this.ammo.weaponUpdate(weaponDesc.getSecAmmoItemType(), Weaponry.this.self.getSecondaryAmmo());
                }
                Weaponry.this.ammo.updateWeaponAmmo(weaponToUpdate);
            }
        }

        public SelfUpdateListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this);
        }
    }

    private class WeaponUpdateListener
    implements IWorldEventListener<WeaponUpdate> {
        @Override
        public void notify(WeaponUpdate event) {
            Weapon weapon;
            if (event == null) {
                return;
            }
            if (event.getInventoryType() == null) {
                return;
            }
            WeaponDescriptor weaponDesc = (WeaponDescriptor)Weaponry.this.itemDescriptors.getDescriptor(event.getInventoryType());
            if (weaponDesc == null && (weapon = (Weapon)((WeaponsByKey)Weaponry.this.weaponsById).all.get(event.getId())) != null) {
                weaponDesc = weapon.getDescriptor();
            }
            if (weaponDesc == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("WeaponUpdateListener.notify(): There is no weapon descriptor for the weapon for the event: " + event);
                }
                return;
            }
            if (weaponDesc.getPriAmmoItemType() != null) {
                Weaponry.this.ammo.weaponUpdate(weaponDesc.getPriAmmoItemType(), event.getPrimaryAmmo());
            }
            if (weaponDesc.getSecAmmoItemType() != null && weaponDesc.getSecAmmoItemType() != weaponDesc.getPriAmmoItemType()) {
                Weaponry.this.ammo.weaponUpdate(weaponDesc.getSecAmmoItemType(), event.getSecondaryAmmo());
            }
            if ((weapon = (Weapon)((WeaponsByKey)Weaponry.this.weaponsByItemType).all.get(weaponDesc.getPickupType())) != null) {
                Weaponry.this.ammo.updateWeaponAmmo(weapon);
            }
        }

        public WeaponUpdateListener(IWorldView worldView) {
            worldView.addEventListener(WeaponUpdate.class, this);
        }
    }

    private class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        @Override
        public void notify(ItemPickedUp event) {
            if (event == null) {
                return;
            }
            if (event.getType() == null) {
                return;
            }
            if (event.getType().getCategory() == ItemType.Category.AMMO || event.getType().getCategory() == ItemType.Category.WEAPON) {
                Weapon weapon;
                Weaponry.this.ammo.itemPickedUp(event);
                if (event.getType().getCategory() == ItemType.Category.AMMO) {
                    ItemType weaponType = Weaponry.this.itemDescriptors.getWeaponForAmmo(event.getType());
                    if (weaponType == null) {
                        if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                            Weaponry.this.log.warning("ItemPickedUpListener.notify(): There is no weapon for the ammo " + event.getType() + ", the weapon probably can not be found in this map.");
                        }
                        return;
                    }
                    weapon = (Weapon)((WeaponsByKey)Weaponry.this.weaponsByItemType).all.get(weaponType);
                } else {
                    ItemType weaponType = event.getType();
                    weapon = (Weapon)((WeaponsByKey)Weaponry.this.weaponsByItemType).all.get(weaponType);
                }
                if (weapon != null) {
                    Weaponry.this.ammo.updateWeaponAmmo(weapon);
                }
            }
        }

        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, this);
        }
    }

    private class AddInventoryMsgListener
    implements IWorldEventListener<AddInventoryMsg> {
        @Override
        public void notify(AddInventoryMsg event) {
            Weapon weapon;
            if (event == null) {
                return;
            }
            if (event.getPickupType() == null) {
                return;
            }
            if (event.getPickupType().getCategory() != ItemType.Category.WEAPON) {
                return;
            }
            if (event.getPickupType() == ItemType.REDEEMER) {
                Weaponry.this.log.info("REDEEMER!");
            }
            if ((weapon = new Weapon(event, Weaponry.this.ammo.getPriAmmoForWeapon(event.getPickupType()), Weaponry.this.ammo.getSecAmmoForWeapon(event.getPickupType()))).getDescriptor() == null) {
                if (Weaponry.this.log.isLoggable(Level.SEVERE)) {
                    Weaponry.this.log.severe("AddInventoryMsgListener.notify(): There is no weapon descriptor for " + weapon.getType() + "!!! The newly gained weapon is not added to the Weaponry!");
                }
                return;
            }
            Weaponry.this.weaponsByGroup.add(event.getPickupType().getGroup(), weapon);
            Weaponry.this.weaponsByItemType.add(event.getPickupType(), weapon);
            Weaponry.this.weaponsById.add(event.getId(), weapon);
            Weaponry.this.weaponTypeToInventoryUnrealId.put(event.getPickupType(), event.getId());
            Weaponry.this.inventoryUnrealIdToWeaponDescriptor.put(event.getId(), (WeaponDescriptor)event.getDescriptor());
        }

        public AddInventoryMsgListener(IWorldView worldView) {
            worldView.addEventListener(AddInventoryMsg.class, this);
        }
    }

    private class WeaponsByKey<KEY> {
        private HashMap<KEY, Weapon> all = new HashMap();
        private HashMap<KEY, Weapon> allLoaded = new HashMap();
        private HashMap<KEY, Weapon> allMelee = new HashMap();
        private HashMap<KEY, Weapon> allRanged = new HashMap();
        private HashMap<KEY, Weapon> allLoadedMelee = new HashMap();
        private HashMap<KEY, Weapon> allLoadedRanged = new HashMap();

        private WeaponsByKey() {
        }

        public void add(KEY key, Weapon inv) {
            if (key == null || inv == null) {
                return;
            }
            if (inv.getDescriptor() == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("WeaponsByKey.add(): Can't add weapon " + inv.getType() + " that has associated weapon descriptor == null!");
                }
                return;
            }
            if (inv.getDescriptor() instanceof WeaponDescriptor) {
                WeaponDescriptor desc = inv.getDescriptor();
                this.all.put(key, inv);
                if (desc.isMelee()) {
                    this.allMelee.put(key, inv);
                    if (inv.getAmmo() > 0) {
                        this.allLoadedMelee.put(key, inv);
                        this.allLoaded.put(key, inv);
                    }
                } else {
                    this.allRanged.put(key, inv);
                    if (inv.getAmmo() > 0) {
                        this.allLoadedRanged.put(key, inv);
                        this.allLoaded.put(key, inv);
                    }
                }
            }
        }

        public void remove(KEY key) {
            this.all.remove(key);
            this.allLoaded.remove(key);
            this.allMelee.remove(key);
            this.allRanged.remove(key);
            this.allLoadedMelee.remove(key);
            this.allLoadedRanged.remove(key);
        }

        public void ammoChanged(KEY key) {
            if (key == null) {
                return;
            }
            Weapon weapon = this.all.get(key);
            if (weapon == null) {
                return;
            }
            if (weapon.getAmmo() > 0) {
                if (!this.allLoaded.containsKey(key)) {
                    WeaponDescriptor desc = weapon.getDescriptor();
                    this.allLoaded.put(key, weapon);
                    if (desc.isMelee()) {
                        this.allLoadedMelee.put(key, weapon);
                    } else {
                        this.allLoadedRanged.put(key, weapon);
                    }
                }
            } else if (this.allLoaded.containsKey(key)) {
                this.allLoaded.remove(key);
                this.allLoadedMelee.remove(key);
                this.allLoadedRanged.remove(key);
            }
        }

        public void botKilled() {
            this.all.clear();
            this.allLoaded.clear();
            this.allLoadedMelee.clear();
            this.allLoadedRanged.clear();
            this.allMelee.clear();
            this.allRanged.clear();
        }
    }

    private class Ammunition {
        private LazyMap<ItemType, Integer> ammo = new LazyMap<ItemType, Integer>(){

            @Override
            protected Integer create(ItemType key) {
                return 0;
            }
        };

        private Ammunition() {
        }

        public int getAmmo(ItemType ammoType) {
            if (ammoType == null) {
                return 0;
            }
            if (ammoType.getCategory() != ItemType.Category.AMMO) {
                return 0;
            }
            return this.ammo.get(ammoType);
        }

        public int getPriAmmoForWeapon(ItemType weapon) {
            if (weapon == null) {
                return 0;
            }
            if (weapon.getCategory() != ItemType.Category.WEAPON) {
                return 0;
            }
            WeaponDescriptor desc = (WeaponDescriptor)Weaponry.this.itemDescriptors.getDescriptor(weapon);
            if (desc == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("Ammunition.getPriAmmoForWeapon(): There is no WeaponDescriptor for the item type " + weapon + "!");
                }
                return 0;
            }
            return this.getAmmo(desc.getPriAmmoItemType());
        }

        public int getSecAmmoForWeapon(ItemType weaponType) {
            if (weaponType == null) {
                return 0;
            }
            if (weaponType.getCategory() != ItemType.Category.WEAPON) {
                return 0;
            }
            WeaponDescriptor desc = (WeaponDescriptor)Weaponry.this.itemDescriptors.getDescriptor(weaponType);
            if (desc == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("Ammunition.getSecAmmoForWeapon(): There is no WeaponDescriptor for the item type " + weaponType + "!");
                }
                return 0;
            }
            if (desc.getSecAmmoItemType() == null) {
                return this.getPriAmmoForWeapon(weaponType);
            }
            return this.getAmmo(desc.getSecAmmoItemType());
        }

        public int getAmmoForWeapon(ItemType weaponType) {
            if (weaponType == null) {
                return 0;
            }
            if (weaponType.getCategory() != ItemType.Category.WEAPON) {
                return 0;
            }
            WeaponDescriptor desc = (WeaponDescriptor)Weaponry.this.itemDescriptors.getDescriptor(weaponType);
            if (desc == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("Ammunition.getAmmoForWeapon(): There is no WeaponDescriptor for the item type " + weaponType + "!");
                }
                return 0;
            }
            if (desc.getSecAmmoItemType() != null && desc.getPriAmmoItemType() != desc.getSecAmmoItemType()) {
                return this.getPriAmmoForWeapon(weaponType) + this.getSecAmmoForWeapon(weaponType);
            }
            return this.getPriAmmoForWeapon(weaponType);
        }

        public void itemPickedUp(ItemPickedUp pickedUp) {
            if (pickedUp == null) {
                return;
            }
            ItemDescriptor descriptor = Weaponry.this.itemDescriptors.getDescriptor(pickedUp.getType());
            if (descriptor == null) {
                if (Weaponry.this.log.isLoggable(Level.WARNING)) {
                    Weaponry.this.log.warning("Ammunition.itemPickedUp(): There is no ItemDescriptor for the item type " + pickedUp.getType() + "!");
                }
                return;
            }
            if (pickedUp.getDescriptor().getPickupType() == ItemType.REDEEMER || pickedUp.getDescriptor().getPickupType() == ItemType.REDEEMER_AMMO || pickedUp.getDescriptor().getPickupType() == ItemType.ION_PAINTER || pickedUp.getDescriptor().getPickupType() == ItemType.ION_PAINTER_AMMO) {
                WeaponDescriptor desc;
                if (descriptor.getItemCategory() == ItemType.Category.AMMO) {
                    if (this.ammo.get(pickedUp.getType()) <= 0) {
                        this.ammo.put(pickedUp.getType(), 1);
                    }
                } else if (descriptor.getItemCategory() == ItemType.Category.WEAPON && this.ammo.get((desc = (WeaponDescriptor)descriptor).getPriAmmoItemType()) == 0) {
                    this.ammo.put(desc.getPriAmmoItemType(), 1);
                }
                return;
            }
            if (descriptor.getItemCategory() == ItemType.Category.AMMO) {
                AmmoDescriptor desc = (AmmoDescriptor)descriptor;
                int current = this.getAmmo(pickedUp.getType());
                if (current + pickedUp.getAmount() > desc.getPriMaxAmount()) {
                    this.ammo.put(pickedUp.getType(), desc.getPriMaxAmount());
                } else {
                    this.ammo.put(pickedUp.getType(), current + pickedUp.getAmount());
                }
            } else if (descriptor.getItemCategory() == ItemType.Category.WEAPON) {
                WeaponDescriptor desc = (WeaponDescriptor)descriptor;
                if (desc.getPriAmmoItemType() != null) {
                    int priWeaponAmmoPlus;
                    int priAmmo = this.ammo.get(desc.getPriAmmoItemType());
                    if (priAmmo + (priWeaponAmmoPlus = pickedUp.getAmount()) <= desc.getPriMaxAmount()) {
                        this.ammo.put(desc.getPriAmmoItemType(), priAmmo + priWeaponAmmoPlus);
                    } else {
                        this.ammo.put(desc.getPriAmmoItemType(), desc.getPriMaxAmount());
                    }
                }
                if (desc.getSecAmmoItemType() != null && desc.getSecAmmoItemType() != desc.getPriAmmoItemType()) {
                    int secWeaponAmmoPlus;
                    int secAmmo = this.ammo.get(desc.getSecAmmoItemType());
                    if (secAmmo + (secWeaponAmmoPlus = pickedUp.getAmountSec()) <= desc.getSecMaxAmount()) {
                        this.ammo.put(desc.getSecAmmoItemType(), secAmmo + secWeaponAmmoPlus);
                    } else {
                        this.ammo.put(desc.getSecAmmoItemType(), desc.getSecMaxAmount());
                    }
                }
            }
        }

        public void weaponUpdate(ItemType ammoType, int amount) {
            if (ammoType == null) {
                return;
            }
            if (ammoType.getCategory() != ItemType.Category.AMMO) {
                if (Weaponry.this.log.isLoggable(Level.SEVERE)) {
                    Weaponry.this.log.severe("Ammunition.weaponUpdate: Can't update weapon ammo, unknown ammo type=" + ammoType.getName() + ", category=" + (Object)((Object)ammoType.getCategory()) + ", group=" + (Object)((Object)ammoType.getGroup()));
                }
                return;
            }
            this.ammo.put(ammoType, amount);
        }

        public void botKilled() {
            this.ammo.clear();
        }

        public void updateWeaponAmmo(Weapon weapon) {
            if (weapon == null) {
                return;
            }
            weapon.primaryAmmo = this.getAmmo(weapon.getDescriptor().getPriAmmoItemType());
            if (weapon.getDescriptor().getSecAmmoItemType() != null) {
                weapon.secondaryAmmo = this.getAmmo(weapon.getDescriptor().getSecAmmoItemType());
            }
            Weaponry.this.weaponsByGroup.ammoChanged(weapon.getGroup());
            Weaponry.this.weaponsByItemType.ammoChanged(weapon.getType());
            Weaponry.this.weaponsById.ammoChanged(weapon.getInventoryId());
        }
    }
}

