/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.UUID;

@AgentScoped
public class AgentId
implements IAgentId {
    public static final String AGENT_NAME_DEPENDENCY = "AgentName";
    private static int agentCounter = 0;
    protected static Random random = new Random(System.currentTimeMillis());
    public static final String NO_NAME = "no_name";
    private Flag<String> name = new Flag<String>("no_name");
    private Token token;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentId() {
        UUID uuid = null;
        try {
            Random random = AgentId.random;
            synchronized (random) {
                uuid = new UUID(AgentId.random.nextLong(), AgentId.random.nextLong());
            }
            this.token = Tokens.get(this.getClass().getSimpleName() + "-" + ++agentCounter + "@" + InetAddress.getLocalHost().getCanonicalHostName() + "/" + uuid.toString());
        }
        catch (UnknownHostException ex) {
            if (uuid == null) {
                throw new IllegalStateException("Can't initialize AgentId, instantiation of UUID failed.");
            }
            this.token = Tokens.get(this.getClass().getSimpleName() + "-" + ++agentCounter + "@unknownHost/" + uuid.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public AgentId(@Named(value="AgentName") String agentName) {
        NullCheck.check(agentName, "name");
        UUID uuid = null;
        try {
            Random random = AgentId.random;
            synchronized (random) {
                uuid = new UUID(AgentId.random.nextLong(), AgentId.random.nextLong());
            }
            this.token = Tokens.get(agentName + "-" + ++agentCounter + "@" + InetAddress.getLocalHost().getCanonicalHostName() + "/" + uuid.toString());
        }
        catch (UnknownHostException ex) {
            this.token = Tokens.get(this.getClass().getSimpleName() + "-" + ++agentCounter + "@unknownHost/" + uuid.toString());
        }
        this.getName().setFlag(agentName);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentId)) {
            return false;
        }
        return this.token.equals(((AgentId)obj).token);
    }

    @Override
    public Flag<String> getName() {
        return this.name;
    }

    @Override
    public long[] getIds() {
        return this.token.getIds();
    }

    @Override
    public String getToken() {
        return this.token.getToken();
    }

    public String toString() {
        return "AgentId[" + this.getToken() + "]";
    }
}

