/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.translators;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import eis.iilang.Function;
import eis.iilang.Numeral;
import eis.iilang.Parameter;
import java.util.LinkedList;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Java2Parameter;
import nl.tudelft.goal.EIS2Java.translation.Parameter2Java;

public class LocationTranslator
implements Parameter2Java<Location>,
Java2Parameter<Location> {
    public static String LOCATION_KEYWORD = "location";

    @Override
    public Location translate(Parameter p) throws TranslationException {
        if (!(p instanceof Function)) {
            String message = String.format("A location must be a function, received: %s.", p);
            throw new TranslationException(message);
        }
        Function f = (Function)p;
        if (!f.getName().equals(LOCATION_KEYWORD)) {
            String message = String.format("A location needs to start with %s, not: %s in %s.", LOCATION_KEYWORD, f.getName(), f);
            throw new TranslationException(message);
        }
        LinkedList parameters = f.getParameters();
        if (parameters.size() != 3) {
            String message = String.format("Expected exactly 3 parameters when parsing %s", f);
            throw new TranslationException(message);
        }
        for (Parameter parameter : parameters) {
            if (parameter instanceof Numeral) continue;
            String message = String.format("All arguments of %s should be numerical.", f);
            throw new TranslationException(message);
        }
        double[] coord = new double[3];
        for (int i = 0; i < coord.length; ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            coord[i] = ((Numeral)parameter).getValue().doubleValue();
        }
        return new Location(coord);
    }

    @Override
    public Class<Location> translatesTo() {
        return Location.class;
    }

    @Override
    public Parameter[] translate(Location o) throws TranslationException {
        return new Parameter[]{new Function(LOCATION_KEYWORD, new Parameter[]{new Numeral((Number)o.x), new Numeral((Number)o.y), new Numeral((Number)o.z)})};
    }

    @Override
    public Class<? extends Location> translatesFrom() {
        return Location.class;
    }
}

