/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.environment;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Pause;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import eis.exceptions.EntityException;
import eis.exceptions.ManagementException;
import eis.exceptions.RelationException;
import eis.iilang.Action;
import eis.iilang.EnvironmentState;
import eis.iilang.Parameter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.tudelft.goal.EIS2Java.handlers.ActionHandler;
import nl.tudelft.goal.EIS2Java.handlers.PerceptHandler;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import nl.tudelft.goal.unreal.environment.SimpleTransitioningEnvironment;
import nl.tudelft.goal.unreal.environment.UnrealEnvironmentException;
import nl.tudelft.goal.unreal.messages.BotParameters;
import nl.tudelft.goal.unreal.messages.EnvironmentParameters;
import nl.tudelft.goal.unreal.translators.AgentIdTranslator;
import nl.tudelft.goal.unreal.translators.LevelTranslator;
import nl.tudelft.goal.unreal.translators.LocationTranslator;
import nl.tudelft.goal.unreal.translators.RotationTranslator;
import nl.tudelft.goal.unreal.translators.SkinTranslator;
import nl.tudelft.goal.unreal.translators.StringListTranslator;
import nl.tudelft.goal.unreal.translators.TeamTranslator;
import nl.tudelft.goal.unreal.translators.URITranslator;
import nl.tudelft.pogamut.base.server.ReconnectingServerDefinition;
import nl.tudelft.pogamut.ut2004.server.UTServerDefinition;

public abstract class AbstractUnrealEnvironment
extends SimpleTransitioningEnvironment
implements IComponent {
    private static final long serialVersionUID = 6786623950045095814L;
    protected final IAgentId id = new AgentId(this.getName());
    protected final IAgentLogger environmentLogger;
    protected final LogCategory log;
    private final Map<String, AgentDownListener> agentDownListeners = new HashMap<String, AgentDownListener>();
    protected BotParameters botParameters;
    protected EnvironmentParameters environmentParameters;
    private ReconnectingServerDefinition<IUT2004Server> utServerConnection;

    public AbstractUnrealEnvironment() {
        this.environmentLogger = new AgentLogger(this.id);
        this.environmentLogger.addDefaultConsoleHandler();
        this.log = this.environmentLogger.getCategory(this);
        this.log.info("Environment has been created.");
        this.log.addConsoleHandler();
        Translator translator = Translator.getInstance();
        translator.registerParameter2JavaTranslator(new AgentIdTranslator());
        translator.registerParameter2JavaTranslator(new LevelTranslator());
        translator.registerParameter2JavaTranslator(new SkinTranslator());
        translator.registerParameter2JavaTranslator(new StringListTranslator());
        translator.registerParameter2JavaTranslator(new TeamTranslator());
        translator.registerParameter2JavaTranslator(new URITranslator());
        translator.registerParameter2JavaTranslator(new LocationTranslator());
        translator.registerParameter2JavaTranslator(new RotationTranslator());
        this.registerTranslators();
    }

    protected abstract void registerTranslators();

    @Override
    public IAgentId getComponentId() {
        return this.id;
    }

    public String toString() {
        return this.simplefyID(this.getComponentId());
    }

    public String getName() {
        return "UnrealGoal Environment for EIS" + this.requiredVersion();
    }

    @Override
    protected synchronized void initializeEnvironment(Map<String, Parameter> parameters) throws ManagementException {
        assert (this.botParameters == null);
        assert (this.environmentParameters == null);
        try {
            this.botParameters = new BotParameters(parameters, this.environmentLogger);
            this.environmentParameters = new EnvironmentParameters(parameters, this.environmentLogger);
        }
        catch (UnrealEnvironmentException e) {
            this.botParameters = null;
            this.environmentParameters = null;
            this.log.severe("Invalid parameters: " + e);
            throw new ManagementException("Invalid parameters.", (Exception)e);
        }
        this.environmentParameters.assignDefaults(EnvironmentParameters.getDefaults(this.environmentLogger));
        this.botParameters.assignDefaults(BotParameters.getDefaults(this.environmentLogger));
        this.log.setLevel(this.environmentParameters.getLogLevel());
        this.utServerConnection = new ReconnectingServerDefinition<IUT2004Server>(new UTServerDefinition());
    }

    @Override
    protected synchronized void connectEnvironment() throws ManagementException {
        assert (this.botParameters != null);
        assert (this.environmentParameters != null);
        URI utServerURI = this.environmentParameters.getUTServer();
        if (utServerURI != null) {
            this.log.info("Connecting to the control server at " + utServerURI + " .");
            this.utServerConnection.setUri(utServerURI);
        } else {
            this.log.info("No address for the ut control server was provided. The environment will not try to connect to the control server.");
        }
        ArrayList<BotParameters> agentParameters = new ArrayList<BotParameters>();
        for (String name : this.environmentParameters.getBotNames()) {
            BotParameters parameter = new BotParameters(this.botParameters, this.environmentLogger);
            parameter.setAgentId(name);
            agentParameters.add(parameter);
        }
        BotParameters[] agentParameterArray = new BotParameters[agentParameters.size()];
        agentParameterArray = agentParameters.toArray(agentParameterArray);
        this.startAgents(agentParameterArray);
    }

    protected abstract Class<? extends UT2004BotController> getControlerClass();

    protected synchronized void startAgents(BotParameters ... parameters) throws ManagementException {
        String simpleID;
        List agents;
        if (this.getState() == EnvironmentState.KILLED) {
            return;
        }
        IUT2004Server server = this.utServerConnection.getServerFlag().getFlag();
        if (server != null) {
            Pause resume = new Pause(false, false);
            server.getAct().act(resume);
            this.log.info("The server has been unpaused. Required to allow adding bots.");
        } else {
            this.log.warning("We are not connected to ut server and could not unpause the environment.");
        }
        for (BotParameters botParameters : parameters) {
            botParameters.assignDefaults(BotParameters.getDefaults(this.environmentLogger));
        }
        UT2004BotRunner runner = new UT2004BotRunner(this.getControlerClass(), "UnrealGoalBot", "127.0.0.1", 3000);
        runner.setLog(this.log);
        try {
            agents = runner.startAgents(parameters);
        }
        catch (PogamutException e) {
            throw new ManagementException("Pogmut was unable to start all agents. Cause: " + e.toString());
        }
        try {
            for (UT2004Bot agent : agents) {
                simpleID = this.simplefyID(agent.getComponentId());
                UT2004BotController controller = (UT2004BotController)agent.getController();
                this.registerEntity(simpleID, "bot", controller, this.createActionHandler(controller), this.createPerceptHandler(controller));
            }
        }
        catch (EntityException e) {
            for (UT2004Bot agent : agents) {
                agent.stop();
            }
            throw new ManagementException("Unable to register entity", (Exception)((Object)e));
        }
        for (UT2004Bot agent : agents) {
            simpleID = this.simplefyID(agent.getComponentId());
            this.agentDownListeners.put(simpleID, new AgentDownListener(simpleID, agent));
        }
        for (UT2004Bot agent : agents) {
            if (!agent.inState(IAgentStateDown.class)) continue;
            simpleID = this.simplefyID(agent.getComponentId());
            this.agentDownListeners.get(simpleID).removeListener();
            this.synchronizedDeleteEntity(simpleID);
        }
    }

    protected abstract PerceptHandler createPerceptHandler(UT2004BotController var1) throws EntityException;

    protected abstract ActionHandler createActionHandler(UT2004BotController var1) throws EntityException;

    private String simplefyID(IAgentId agentID) {
        String token = agentID.getToken();
        int index = token.lastIndexOf(47);
        if (index < 0) {
            this.log.severe("Could not find UUID seperator in Agent ID: " + token);
            return token;
        }
        return token.substring(0, index);
    }

    @Override
    protected void startEnvironment() throws ManagementException {
        IUT2004Server server = this.utServerConnection.getServerFlag().getFlag();
        if (server != null) {
            Pause resume = new Pause(false, false);
            server.getAct().act(resume);
            this.log.info("The environment has been started.");
        } else {
            this.log.warning("We are not connected to ut server and could not start the environment.");
        }
    }

    @Override
    protected void pauseEvironment() {
        IUT2004Server server = this.utServerConnection.getServerFlag().getFlag();
        if (server != null) {
            Pause pause = new Pause(true, false);
            server.getAct().act(pause);
            this.log.info("The environment has been paused.");
        } else {
            this.log.warning("We are not connected to ut server and could not pause the environment.");
        }
    }

    @Override
    protected synchronized void killEnvironment() {
        IUT2004Server server = this.utServerConnection.getServerFlag().getFlag();
        if (server != null) {
            Pause resume = new Pause(false, false);
            server.getAct().act(resume);
            this.log.info("The environment has been unpaused.");
        } else {
            this.log.warning("We are not connected to ut server and could not unpause the environment.");
        }
        for (String id : this.getEntities()) {
            UT2004BotController controller = (UT2004BotController)this.getEntity(id);
            Object bot = controller.getBot();
            try {
                this.agentDownListeners.get(id).removeListener();
                ((AbstractAgent)bot).stop();
                this.log.info(((AbstractAgent)bot).getName() + " has been stopped");
            }
            catch (AgentException e) {
                this.log.info(((AbstractAgent)bot).getName() + " has been killed", e);
            }
        }
        this.utServerConnection.stopServer();
        this.botParameters = null;
        this.environmentParameters = null;
        Pogamut.getPlatform().close();
    }

    protected synchronized void synchronizedDeleteEntity(String name) {
        try {
            this.deleteEntity(name);
        }
        catch (RelationException e) {
            this.log.severe("Could not delete entity " + name);
        }
        catch (EntityException e) {
            this.log.severe("Could not delete entity " + name + ", it was already deleted.");
        }
    }

    protected boolean isSupportedByEnvironment(Action arg0) {
        return true;
    }

    protected boolean isSupportedByType(Action arg0, String arg1) {
        return true;
    }

    private class AgentDownListener
    implements FlagListener<IAgentState> {
        private final String key;
        private final UT2004Bot agent;

        public AgentDownListener(String key, UT2004Bot agent) {
            this.key = key;
            this.agent = agent;
            this.agent.getState().addStrongListener(this);
        }

        @Override
        public void flagChanged(IAgentState state) {
            if (state instanceof IAgentStateDown) {
                this.removeListener();
                AbstractUnrealEnvironment.this.synchronizedDeleteEntity(this.key);
            }
        }

        public void removeListener() {
            this.agent.getState().removeListener(this);
            AbstractUnrealEnvironment.this.agentDownListeners.remove(this.key);
        }
    }
}

