/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.EIS2Java.util;

import eis.exceptions.EntityException;
import eis.iilang.Action;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.tudelft.goal.EIS2Java.annotation.AsAction;
import nl.tudelft.goal.EIS2Java.annotation.AsAllPercepts;
import nl.tudelft.goal.EIS2Java.annotation.AsPercept;

public class EIS2JavaUtil {
    public static Set<Method> processPerceptAnnotations(Class<?> clazz) throws EntityException {
        HashSet<Method> percepts = new HashSet<Method>();
        for (Method method : clazz.getMethods()) {
            AsPercept asPercept = method.getAnnotation(AsPercept.class);
            if (asPercept == null) continue;
            if (method.getParameterTypes().length != 0) {
                throw new EntityException("Percepts may not have any arguments");
            }
            percepts.add(method);
        }
        return percepts;
    }

    public static Method processAllPerceptAnnotation(Class<?> clazz) throws EntityException {
        Method allPercepts = null;
        for (Method method : clazz.getMethods()) {
            AsAllPercepts asAllPercept = method.getAnnotation(AsAllPercepts.class);
            if (asAllPercept == null) continue;
            if (allPercepts != null) {
                throw new EntityException("Found two definitions for all percepts");
            }
            if (!method.getReturnType().equals(Map.class)) {
                throw new EntityException("All percepts must return a Map<Method,Object>");
            }
            if (method.getParameterTypes().length != 0) {
                throw new EntityException("All percepts may not have any arguments");
            }
            allPercepts = method;
        }
        return allPercepts;
    }

    public static Map<String, Method> processActionAnnotations(Class<?> clazz) throws EntityException {
        HashMap<String, Method> actions = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            AsAction asAction = method.getAnnotation(AsAction.class);
            if (asAction == null) continue;
            String name = EIS2JavaUtil.getNameOfAction(method);
            if (actions.containsKey(name)) {
                throw new EntityException("Found two action definitions with the same name: " + name);
            }
            actions.put(name, method);
        }
        return actions;
    }

    public static String getNameOfAction(Action action) {
        return action.getName() + "/" + action.getParameters().size();
    }

    public static String getNameOfAction(Method method) {
        AsAction annotation = method.getAnnotation(AsAction.class);
        if (annotation == null) {
            return null;
        }
        return annotation.name() + "/" + method.getParameterTypes().length;
    }

    public static String getNameOfPercept(Method method) {
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        if (annotation == null) {
            return null;
        }
        return annotation.name();
    }
}

