/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.EIS2Java.environment;

import eis.EIDefaultImpl;
import eis.exceptions.ActException;
import eis.exceptions.EntityException;
import eis.exceptions.NoEnvironmentException;
import eis.exceptions.PerceiveException;
import eis.exceptions.RelationException;
import eis.iilang.Action;
import eis.iilang.Percept;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import nl.tudelft.goal.EIS2Java.handlers.ActionHandler;
import nl.tudelft.goal.EIS2Java.handlers.DefaultActionHandler;
import nl.tudelft.goal.EIS2Java.handlers.DefaultPerceptHandler;
import nl.tudelft.goal.EIS2Java.handlers.PerceptHandler;

public abstract class AbstractEnvironment
extends EIDefaultImpl {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> entities = new HashMap<String, Object>();
    private final Map<String, PerceptHandler> perceptHandlers = new HashMap<String, PerceptHandler>();
    private final Map<String, ActionHandler> actionHandlers = new HashMap<String, ActionHandler>();

    public final <T> void registerEntity(String name, T entity) throws EntityException {
        this.registerEntity(name, entity, new DefaultActionHandler(entity), new DefaultPerceptHandler(entity));
    }

    public final <T> void registerEntity(String name, T entity, ActionHandler actionHandler, PerceptHandler perceptHandler) throws EntityException {
        this.actionHandlers.put(name, actionHandler);
        this.perceptHandlers.put(name, perceptHandler);
        this.entities.put(name, entity);
        this.addEntity(name);
    }

    public final <T> void registerEntity(String name, String type, T entity) throws EntityException {
        this.registerEntity(name, type, entity, new DefaultActionHandler(entity), new DefaultPerceptHandler(entity));
    }

    public final <T> void registerEntity(String name, String type, T entity, ActionHandler actionHandler, PerceptHandler perceptHandler) throws EntityException {
        this.actionHandlers.put(name, actionHandler);
        this.perceptHandlers.put(name, perceptHandler);
        this.entities.put(name, entity);
        this.addEntity(name, type);
    }

    public final void deleteEntity(String name) throws EntityException, RelationException {
        super.deleteEntity(name);
        this.entities.remove(name);
        this.actionHandlers.remove(name);
        this.perceptHandlers.remove(name);
    }

    public final <T> T getEntity(String name) {
        return (T)this.entities.get(name);
    }

    protected final LinkedList<Percept> getAllPerceptsFromEntity(String name) throws PerceiveException, NoEnvironmentException {
        PerceptHandler handler = this.perceptHandlers.get(name);
        if (handler == null) {
            throw new PerceiveException("Entity with name " + name + " has no handler");
        }
        return handler.getAllPercepts();
    }

    protected final boolean isSupportedByEntity(Action action, String name) {
        Object entity = this.getEntity(name);
        ActionHandler handler = this.actionHandlers.get(entity);
        return handler.isSupportedByEntity(action);
    }

    protected final Percept performEntityAction(String name, Action action) throws ActException {
        ActionHandler handler = this.actionHandlers.get(name);
        if (handler == null) {
            throw new ActException(7, "Entity with name " + name + " has no handler");
        }
        return handler.performAction(action);
    }

    public final String requiredVersion() {
        return "0.3";
    }
}

