/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class CEExecutor
extends AbstractExecutor
implements ElementExecutor {
    private PoshPlan plan;
    private PrimitiveCall actionCall;
    private String name;
    private SenseListExecutor<CompetenceElement> trigger;
    private int retries = 0;
    private int maxRetries;
    private TriggerResult result;
    private boolean actionCalled = false;

    CEExecutor(PoshPlan plan, CompetenceElement ce, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.name = ce.getName();
        this.trigger = new SenseListExecutor<CompetenceElement>(ce.getTrigger(), ctx, log);
        this.maxRetries = ce.getRetries();
        this.plan = plan;
        this.actionCall = ce.getAction().getActionCall();
    }

    private StackElement createActionExecutor(PoshPlan plan, PrimitiveCall actionCall) {
        return this.getElement(plan, actionCall, FireResult.Type.SURFACE_CONTINUE, FireResult.Type.SURFACE, FireResult.Type.SURFACE, FireResult.Type.FAILED);
    }

    TriggerResult isReady(IWorkExecutor workExecuter) {
        this.fine("isReady? " + this.retries + "/" + this.maxRetries);
        this.result = this.maxRetries == -1 || this.retries < this.maxRetries ? this.trigger.fire(workExecuter, true) : new TriggerResult(false);
        return this.result;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (this.actionCalled) {
            this.actionCalled = false;
            return new FireResult(FireResult.Type.SURFACE);
        }
        ++this.retries;
        this.actionCalled = true;
        return new FireResult(FireResult.Type.FOLLOW, this.createActionExecutor(this.plan, this.actionCall));
    }

    String getName() {
        return this.name;
    }

    @Override
    public TriggerResult getTriggerResult() {
        return this.result;
    }
}

