/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;

public class Sense
extends NamedLapElement
implements Comparable<Sense> {
    private PrimitiveCall senseCall;
    private boolean compare = true;
    private Predicate _predicate = Predicate.DEFAULT;
    private Object operand = true;
    public static final String psSenseName = "paSenseName";
    public static final String psArgs = "paSenseArgs";
    public static final String psPredicateIndex = "paPredicate";
    public static final String psValue = "paValue";
    public static final String psType = "paType";
    public static final DataFlavor dataFlavor = new DataFlavor(Sense.class, "sense");

    public Sense(String senseName) {
        this(new PrimitiveCall(senseName));
    }

    public Sense(PrimitiveCall senseCall) {
        this.senseCall = senseCall;
        this.compare = false;
    }

    public Sense(PrimitiveCall senseCall, Object operand, Predicate predicate) {
        assert (predicate != null);
        this.senseCall = senseCall;
        this.compare = true;
        this.operand = operand;
        this._predicate = predicate;
    }

    public String getSenseName() {
        return this.senseCall.getName();
    }

    public PrimitiveCall getSenseCall() {
        return this.senseCall;
    }

    public void setSenseName(String newSenseName) throws InvalidNameException {
        if (!(newSenseName = newSenseName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw InvalidNameException.create(newSenseName);
        }
        String oldSenseName = this.senseCall.getName();
        this.senseCall = new PrimitiveCall(newSenseName, this.senseCall.getParameters());
        this.firePropertyChange(psSenseName, oldSenseName, newSenseName);
    }

    public String getValueString() {
        if (this.operand == null) {
            return "nil";
        }
        if (this.operand instanceof String) {
            return '\"' + this.operand.toString() + '\"';
        }
        return this.operand.toString();
    }

    public Object getOperand() {
        return this.operand;
    }

    public void setOperand(Object newValue) {
        this.operand = newValue;
        this.firePropertyChange(psValue, this.operand, this.operand);
    }

    public Integer getPredicateIndex() {
        return this._predicate.getId();
    }

    public Predicate getPredicate() {
        return this._predicate;
    }

    public void setPredicate(Predicate newPredicate) {
        this.compare = true;
        this._predicate = newPredicate;
        this.firePropertyChange(psPredicateIndex, null, newPredicate.getId());
    }

    public void setPredicateIndex(Integer newPredicateIndex) {
        if (newPredicateIndex != null) {
            this._predicate = Predicate.values()[newPredicateIndex];
            this.firePropertyChange(psPredicateIndex, null, newPredicateIndex);
        } else {
            this._predicate = Predicate.DEFAULT;
            this.firePropertyChange(psPredicateIndex, null, Predicate.DEFAULT.getId());
        }
    }

    public void setArguments(Arguments newArguments) {
        String senseName = this.senseCall.getName();
        Arguments oldArguments = this.senseCall.getParameters();
        this.senseCall = new PrimitiveCall(senseName, newArguments);
        this.firePropertyChange(psArgs, oldArguments, newArguments);
    }

    private FormalParameters getParentParameters() {
        Object parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof DriveElement) {
            return new FormalParameters();
        }
        if (parent instanceof DriveCollection) {
            return new FormalParameters();
        }
        if (parent instanceof CompetenceElement) {
            CompetenceElement cel = (CompetenceElement)parent;
            Competence competence = (Competence)cel.getParent();
            return competence.getParameters();
        }
        throw new IllegalStateException("Unexpected parent " + parent.getClass().getCanonicalName());
    }

    public void parseSense(String input) throws ParseException {
        String adjustedInput = '(' + input + ')';
        PoshParser parser2 = new PoshParser(new StringReader(adjustedInput));
        FormalParameters parameters = this.getParentParameters();
        Sense parsedSense = parser2.fullSense(parameters);
        this.changeTo(parsedSense);
    }

    public void changeTo(Sense other) throws InvalidNameException {
        this.compare = other.compare;
        this.setSenseName(other.getSenseName());
        this.setArguments(other.senseCall.getParameters());
        this.setOperand(other.getOperand());
        this.setPredicateIndex(other.getPredicateIndex());
    }

    public String toString() {
        String res = "(" + this.senseCall;
        if (this.compare) {
            res = this.operand instanceof String ? res + " \"" + this.operand + '\"' : res + " " + this.operand;
            if (this._predicate != Predicate.DEFAULT) {
                res = res + " " + (Object)((Object)this._predicate);
            }
        }
        return res + ")";
    }

    @Override
    public String getName() {
        return this.senseCall.getName();
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        return Collections.emptyList();
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    public String getRepresentation() {
        return this.getRepresentation(this.getSenseName());
    }

    public String getRepresentation(String name) {
        StringBuilder representation = new StringBuilder(name);
        Arguments args = this.senseCall.getParameters();
        if (!args.isEmpty()) {
            representation.append('(').append(args.toString()).append(')');
        }
        boolean predicateIsEqual = this._predicate == Predicate.EQUAL || this._predicate == Predicate.DEFAULT;
        boolean valueIsTrue = Boolean.TRUE.equals(this.operand);
        if (!predicateIsEqual || !valueIsTrue) {
            representation.append((Object)this._predicate);
            representation.append(this.operand);
        }
        return representation.toString();
    }

    @Override
    public int compareTo(Sense o) {
        return this.getRepresentation().compareTo(o.getRepresentation());
    }

    public Trigger<?> getTrigger() {
        Trigger<NamedLapElement> senseTrigger;
        Object senseParent = this.getParent();
        if (senseParent instanceof DriveCollection) {
            DriveCollection dc = (DriveCollection)senseParent;
            senseTrigger = dc.getGoal();
        } else if (senseParent instanceof CompetenceElement) {
            CompetenceElement celParent = (CompetenceElement)senseParent;
            senseTrigger = celParent.getTrigger();
        } else if (senseParent instanceof DriveElement) {
            DriveElement driveParent = (DriveElement)senseParent;
            senseTrigger = driveParent.getTrigger();
        } else {
            throw new IllegalArgumentException("Unexpected parent of sense " + this.getRepresentation() + ": " + senseParent);
        }
        return senseTrigger;
    }

    public void removeFromParent() {
        assert (this.getParent() != null);
        Trigger<?> senseTrigger = this.getTrigger();
        senseTrigger.remove(this);
    }

    public static enum Predicate {
        EQUAL(new String[]{"==", "="}),
        NOT_EQUAL("!="),
        LOWER("<"),
        GREATER(">"),
        LOWER_OR_EQUAL("<="),
        GREATER_OR_EQUAL(">="),
        DEFAULT("==");

        private String[] stringForm = null;

        private Predicate(String form) {
            this.stringForm = new String[]{form};
        }

        private Predicate(String[] form) {
            this.stringForm = form;
        }

        public static Predicate getPredicate(String str) {
            if (str == null) {
                return DEFAULT;
            }
            str = str.trim();
            for (Predicate p : Predicate.values()) {
                for (String form : p.stringForm) {
                    if (!form.equals(str)) continue;
                    return p;
                }
            }
            throw new IllegalArgumentException("String \"" + str + "\" is not a predicate.");
        }

        public int getId() {
            for (int i = 0; i < Predicate.values().length; ++i) {
                if (Predicate.values()[i] != this) continue;
                return i;
            }
            throw new RuntimeException("Predicate \"" + this.toString() + "\" wasn't found in list of predicates.");
        }

        public String toString() {
            return this.stringForm[0];
        }
    }
}

