/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

public class BitMatrix
implements Serializable {
    private static final long serialVersionUID = -6276264641650851997L;
    private BitSet[] matrix;
    private int rows;

    public BitMatrix(int columns, int rows) {
        this.rows = rows;
        this.matrix = new BitSet[columns];
        int i = 0;
        while (i < columns) {
            this.matrix[i] = new BitSet(this.rows);
            ++i;
        }
    }

    public void set(int column, int row) {
        this.matrix[column].set(row);
    }

    public void set(int column, int row, boolean state) {
        if (state) {
            this.set(column, row);
        } else {
            this.unset(column, row);
        }
    }

    public void flip(int column, int row) {
        this.matrix[column].flip(row);
    }

    public void unset(int column, int row) {
        this.matrix[column].clear(row);
    }

    public BitSet getColumn(int column) {
        return this.matrix[column];
    }

    public boolean get(int column, int row) {
        return this.matrix[column].get(row);
    }

    public BitSet and(int ... columns) {
        if (columns == null) {
            return null;
        }
        if (columns.length == 1) {
            return this.getColumn(columns[0]);
        }
        BitSet set = (BitSet)this.getColumn(columns[0]).clone();
        int i = 1;
        while (i < columns.length) {
            set.and(this.getColumn(columns[i]));
            ++i;
        }
        return set;
    }

    public BitSet and(Collection<Integer> columns) {
        if (columns == null) {
            return null;
        }
        Iterator<Integer> keyIter = columns.iterator();
        BitSet set = (BitSet)this.getColumn(keyIter.next()).clone();
        while (keyIter.hasNext()) {
            set.and(this.getColumn(keyIter.next()));
        }
        return set;
    }

    public BitSet or(int ... columns) {
        if (columns == null) {
            return null;
        }
        if (columns.length == 1) {
            return this.getColumn(columns[0]);
        }
        BitSet set = (BitSet)this.getColumn(columns[0]).clone();
        int i = 1;
        while (i < columns.length) {
            set.or(this.getColumn(columns[i]));
            ++i;
        }
        return set;
    }

    public BitSet or(Collection<Integer> columns) {
        if (columns == null) {
            return null;
        }
        Iterator<Integer> keyIter = columns.iterator();
        BitSet set = (BitSet)this.getColumn(keyIter.next()).clone();
        while (keyIter.hasNext()) {
            set.or(this.getColumn(keyIter.next()));
        }
        return set;
    }

    public int columns() {
        return this.matrix.length;
    }

    public int rows() {
        return this.rows;
    }

    public String toString() {
        return "BitMatrix[" + this.columns() + "x" + this.rows + "]";
    }

    public void saveToFile(File file) {
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(file));
            try {
                output.writeObject(this);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save bitmatrix.", e);
        }
    }

    public static BitMatrix loadFromFile(File file) {
        try {
            BitMatrix matrix;
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(file));
            try {
                matrix = (BitMatrix)input.readObject();
            }
            finally {
                input.close();
            }
            return matrix;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save bitmatrix.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load bitmatrix.", e);
        }
    }

    public static void flip(BitSet bitSet) {
        bitSet.flip(0, bitSet.length());
    }
}

