/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavLinkPair;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import math.geom3d.Point3D;
import math.geom3d.line.StraightLine3D;

public class NavigationGraphHelper
extends SensorModule<UT2004Bot> {
    public static final DistanceUtils.IGetDistance<NavPointNeighbourLink> NAV_LINK_GET_DISTANCE = new DistanceUtils.IGetDistance<NavPointNeighbourLink>(){

        @Override
        public double getDistance(NavPointNeighbourLink object, ILocated point) {
            if (object == null) {
                return Double.MAX_VALUE;
            }
            if (point == null) {
                return Double.MAX_VALUE;
            }
            Location x0 = point.getLocation();
            Location x1 = object.getFromNavPoint().getLocation();
            Location x2 = object.getToNavPoint().getLocation();
            double distance = x0.sub(x1).cross(x0.sub(x2)).getLength() / x2.sub(x1).getLength();
            return distance;
        }
    };
    public static final DistanceUtils.IGetDistance<NavLinkPair> NAV_LINK_PAIR_GET_DISTANCE = new DistanceUtils.IGetDistance<NavLinkPair>(){

        @Override
        public double getDistance(NavLinkPair object, ILocated target) {
            return object.getDistance(target.getLocation());
        }
    };
    protected Map<UnrealId, Set<NavLinkPair>> navPointLinks = new LazyMap<UnrealId, Set<NavLinkPair>>(){

        @Override
        protected Set<NavLinkPair> create(UnrealId key) {
            return new HashSet<NavLinkPair>();
        }
    };
    protected Set<NavLinkPair> navLinkPairs = new HashSet<NavLinkPair>();
    protected MapPointListObtainedListener mapPointListObtainedListener;

    public NavPoint getNearestNavPoint() {
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), ((UT2004Bot)this.agent).getLocation());
    }

    public NavPoint getNearestNavPoint(double maxDistance) {
        NavPoint result = DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), ((UT2004Bot)this.agent).getLocation());
        if (result == null) {
            return null;
        }
        if (((UT2004Bot)this.agent).getLocation().getDistance(result.getLocation()) > maxDistance) {
            return null;
        }
        return result;
    }

    public NavLinkPair getNearestNavLinkPair() {
        return DistanceUtils.getNearest(this.navLinkPairs, (ILocated)((UT2004Bot)this.agent).getLocation(), NAV_LINK_PAIR_GET_DISTANCE);
    }

    public NavPoint getNearestNavPoint(ILocated target) {
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), target);
    }

    public NavPoint getNearestNavPoint(ILocated target, double maxDistance) {
        if (target == null || target.getLocation() == null) {
            return null;
        }
        NavPoint result = DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), target);
        if (result == null) {
            return null;
        }
        if (target.getLocation().getDistance(result.getLocation()) > maxDistance) {
            return null;
        }
        return result;
    }

    public NavLinkPair getNearestNavLinkPair(ILocated target) {
        return DistanceUtils.getNearest(this.navLinkPairs, target, NAV_LINK_PAIR_GET_DISTANCE);
    }

    public static Location projectPointToLinkLine(NavPointNeighbourLink link, ILocated point) {
        if (link == null || point == null || point.getLocation() == null) {
            return null;
        }
        StraightLine3D line = new StraightLine3D(link.getFromNavPoint().getLocation().asPoint3D(), link.getToNavPoint().getLocation().asPoint3D());
        Point3D result = line.projectPoint(point.getLocation().asPoint3D());
        return new Location(result);
    }

    public static Boolean isPointProjectionOnLinkSegment(NavPointNeighbourLink link, ILocated point) {
        if (link == null || point == null || point.getLocation() == null) {
            return null;
        }
        StraightLine3D line = new StraightLine3D(link.getFromNavPoint().getLocation().asPoint3D(), link.getToNavPoint().getLocation().asPoint3D());
        double u = line.project(point.getLocation().asPoint3D());
        if (u >= 0.0 && u <= 1.0) {
            return true;
        }
        return false;
    }

    public static Boolean isPointProjectionBeforeLinkSegment(NavPointNeighbourLink link, ILocated point) {
        if (link == null || point == null || point.getLocation() == null) {
            return null;
        }
        StraightLine3D line = new StraightLine3D(link.getFromNavPoint().getLocation().asPoint3D(), link.getToNavPoint().getLocation().asPoint3D());
        double u = line.project(point.getLocation().asPoint3D());
        if (u < 0.0) {
            return true;
        }
        return false;
    }

    public static Boolean isPointProjectionAfterLinkSegment(NavPointNeighbourLink link, ILocated point) {
        if (link == null || point == null || point.getLocation() == null) {
            return null;
        }
        StraightLine3D line = new StraightLine3D(link.getFromNavPoint().getLocation().asPoint3D(), link.getToNavPoint().getLocation().asPoint3D());
        double u = line.project(point.getLocation().asPoint3D());
        if (u > 1.0) {
            return true;
        }
        return false;
    }

    protected void init(Collection<NavPoint> navPoints) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Computing nav-link pairs...");
        }
        this.navPointLinks.clear();
        this.navLinkPairs.clear();
        if (navPoints.size() == 0) {
            return;
        }
        HashSet<NavPointNeighbourLink> finishedLinks = new HashSet<NavPointNeighbourLink>();
        HashSet<NavPoint> finished = new HashSet<NavPoint>();
        HashSet<NavPoint> pending = new HashSet<NavPoint>();
        pending.add(navPoints.iterator().next());
        while (pending.size() > 0) {
            Iterator pendingIterator = pending.iterator();
            NavPoint nav1 = (NavPoint)pendingIterator.next();
            pendingIterator.remove();
            for (NavPointNeighbourLink outgoing : nav1.getOutgoingEdges().values()) {
                if (finishedLinks.contains(outgoing)) continue;
                NavPoint nav2 = outgoing.getToNavPoint();
                NavPointNeighbourLink incoming = outgoing.getToNavPoint().getOutgoingEdges().get(nav2.getId());
                NavLinkPair pair = new NavLinkPair(outgoing, incoming);
                this.navPointLinks.get(nav1.getId()).add(pair);
                this.navPointLinks.get(nav2.getId()).add(pair);
                this.navLinkPairs.add(pair);
                finishedLinks.add(outgoing);
                if (incoming != null) {
                    finishedLinks.add(incoming);
                }
                if (finished.contains(nav2)) continue;
                pending.add(nav2);
            }
            finished.add(nav1);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Computed nav-link pairs.");
        }
    }

    public NavigationGraphHelper(UT2004Bot bot) {
        super(bot);
        this.mapPointListObtainedListener = new MapPointListObtainedListener(bot.getWorldView());
        if (bot.getWorldView().getAll(NavPoint.class).size() > 0) {
            this.init(bot.getWorldView().getAll(NavPoint.class).values());
        }
    }

    protected class MapPointListObtainedListener
    implements IWorldEventListener<MapPointListObtained> {
        public MapPointListObtainedListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, this);
        }

        @Override
        public void notify(MapPointListObtained event) {
            if (event.getNavPoints() != null) {
                NavigationGraphHelper.this.init(event.getNavPoints().values());
            }
        }
    }
}

