/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.lifecyclebus;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.IComponentAware;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResetEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartingPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ComponentBusErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorPropagatingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResetEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentBusErrorException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentBusNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentIdClashException;
import cz.cuni.amis.pogamut.base.component.bus.exception.FatalErrorPropagatingEventException;
import cz.cuni.amis.pogamut.base.component.bus.exception.MoreComponentsForClassException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ResetFailedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.IComponentController;
import cz.cuni.amis.pogamut.base.component.exception.ComponentLifecycleManagementAlreadyRegisteredException;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.sets.ConcurrentHashSet;
import cz.cuni.amis.utils.sets.ConcurrentLinkedHashSet;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public class LifecycleBus
implements ILifecycleBus,
IComponentAware {
    public static final IToken COMPONENT_ID = Tokens.get("LifecycleBus");
    private Map<IToken, IComponent> componentsByToken = new ConcurrentHashMap<IToken, IComponent>();
    private Map<Class, Set<IComponent>> componentsByClass = new LazyMap<Class, Set<IComponent>>(new ConcurrentHashMap()){

        @Override
        protected Set<IComponent> create(Class key) {
            return new ConcurrentHashSet<IComponent>();
        }
    };
    private Map<Class, Set<IComponentEventListener>> eventListeners = new LazyMap<Class, Set<IComponentEventListener>>(new ConcurrentHashMap()){

        @Override
        protected Set<IComponentEventListener> create(Class key) {
            return new ConcurrentLinkedHashSet<IComponentEventListener>();
        }
    };
    private Map<Class, Map<Class, Set<IComponentEventListener>>> componentEventListeners = new LazyMap<Class, Map<Class, Set<IComponentEventListener>>>(new ConcurrentHashMap()){

        @Override
        protected Map<Class, Set<IComponentEventListener>> create(Class key) {
            return new LazyMap<Class, Set<IComponentEventListener>>(new ConcurrentHashMap()){

                @Override
                protected Set<IComponentEventListener> create(Class key) {
                    return new ConcurrentLinkedHashSet<IComponentEventListener>();
                }
            };
        }
    };
    private Map<IToken, Map<Class, Set<IComponentEventListener>>> componentNameEventListeners = new LazyMap<IToken, Map<Class, Set<IComponentEventListener>>>(){

        @Override
        protected Map<Class, Set<IComponentEventListener>> create(IToken key) {
            return new LazyMap<Class, Set<IComponentEventListener>>(new ConcurrentHashMap()){

                @Override
                protected Set<IComponentEventListener> create(Class key) {
                    return new ConcurrentLinkedHashSet<IComponentEventListener>();
                }
            };
        }
    };
    private boolean running = true;
    private Queue<IComponentEvent> queue = new ConcurrentLinkedQueue<IComponentEvent>();
    private boolean queueProcessing = false;
    private Object queueProcessingMutex = new Object();
    private LogCategory log;
    private IAgentId agentId;
    private Object ctrlMutex = new Object();
    private ComponentDependencies dependencies;
    private Map<IToken, ComponentState> dependencyState = new HashMap<IToken, ComponentState>();
    private Map<ComponentState, Integer> stateCount = new HashMap<ComponentState, Integer>();
    private Flag<ComponentState> componentState = new Flag<ComponentState>(ComponentState.INSTANTIATED);
    private IFatalErrorEvent lastFatalError = null;
    private IComponentEventListener<IStartingEvent> startingListener = new IComponentEventListener<IStartingEvent>(){

        @Override
        public void notify(IStartingEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.STARTING);
        }
    };
    private IComponentEventListener<IStartingPausedEvent> startingPausedListener = new IComponentEventListener<IStartingPausedEvent>(){

        @Override
        public void notify(IStartingPausedEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.STARTING_PAUSED);
        }
    };
    private IComponentEventListener<IStartedEvent> startedListener = new IComponentEventListener<IStartedEvent>(){

        @Override
        public void notify(IStartedEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.RUNNING);
        }
    };
    private IComponentEventListener<IPausingEvent> pausingListener = new IComponentEventListener<IPausingEvent>(){

        @Override
        public void notify(IPausingEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.PAUSING);
        }
    };
    private IComponentEventListener<IPausedEvent> pausedListener = new IComponentEventListener<IPausedEvent>(){

        @Override
        public void notify(IPausedEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.PAUSED);
        }
    };
    private IComponentEventListener<IResumingEvent> resumingListener = new IComponentEventListener<IResumingEvent>(){

        @Override
        public void notify(IResumingEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.RESUMING);
        }
    };
    private IComponentEventListener<IResumedEvent> resumedListener = new IComponentEventListener<IResumedEvent>(){

        @Override
        public void notify(IResumedEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.RUNNING);
        }
    };
    private IComponentEventListener<IStoppingEvent> stoppingListener = new IComponentEventListener<IStoppingEvent>(){

        @Override
        public void notify(IStoppingEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.STOPPING);
        }
    };
    private IComponentEventListener<IStoppedEvent> stoppedListener = new IComponentEventListener<IStoppedEvent>(){

        @Override
        public void notify(IStoppedEvent event) {
            LifecycleBus.this.setComponentState(event.getSource().getComponentId(), ComponentState.STOPPED);
        }
    };
    private IComponentEventListener<IFatalErrorEvent> fatalErrorListener = new IComponentEventListener<IFatalErrorEvent>(){

        @Override
        public void notify(IFatalErrorEvent event) {
            LifecycleBus.this.setComponentStates(ComponentState.KILLED);
        }
    };
    private IComponentEventListener<IResetEvent> resetEventListener = new IComponentEventListener<IResetEvent>(){

        @Override
        public void notify(IResetEvent event) {
            LifecycleBus.this.setComponentStates(ComponentState.RESETED);
        }
    };
    private Map<IToken, ComponentController> controls = new HashMap<IToken, ComponentController>();
    private Map<IToken, Flag<ComponentState>> componentStates = new LazyMap<IToken, Flag<ComponentState>>(){

        @Override
        protected Flag<ComponentState> create(IToken key) {
            return new Flag<ComponentState>(ComponentState.INSTANTIATED);
        }
    };

    @Inject
    public LifecycleBus(IAgentLogger logger) {
        NullCheck.check(logger, "logger");
        this.agentId = logger.getAgentId();
        this.log = logger.getCategory(this);
        NullCheck.check(this.log, "log category returned by the logger");
        this.registerComponentStateListeners();
    }

    public String toString() {
        return "LifecycleBus[" + this.agentId.getToken() + ", running=" + this.running + ", queue length=" + (this.queue == null ? "null" : Integer.valueOf(this.queue.size())) + "]";
    }

    @Override
    public IComponentBus getEventBus() {
        return this;
    }

    @Override
    public IToken getComponentId() {
        return COMPONENT_ID;
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public synchronized void reset() throws ResetFailedException {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("reset() called.");
        }
        try {
            if (this.running) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(COMPONENT_ID.getToken() + " is still running, broadcasting fatal error to stop all components.");
                }
                this.event(new FatalErrorEvent<LifecycleBus>(this, "Resetting."));
            }
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Broadcasting reset event.");
            }
            this.resetBus();
            this.innerRaiseEvent(new ResetEvent<LifecycleBus>(this));
        }
        catch (Exception e) {
            if (e instanceof ComponentBusErrorException) {
                this.innerRaiseEvent(new FatalErrorEvent<LifecycleBus>(this, "Reset failed.", e.getCause()));
                throw new ResetFailedException(e.getCause(), (Logger)this.log, this);
            }
            this.innerRaiseEvent(new FatalErrorEvent<LifecycleBus>(this, "Reset failed.", e));
            throw new ResetFailedException((Throwable)e, (Logger)this.log, this);
        }
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Reseted, bus is running again.");
        }
    }

    private void resetBus() {
        this.running = true;
        this.queue.clear();
        this.queueProcessing = false;
    }

    @Override
    public <T> T getComponent(Class<T> cls) throws MoreComponentsForClassException {
        Set<IComponent> components = this.componentsByClass.get(cls);
        if (components.size() > 0) {
            throw new MoreComponentsForClassException(cls, components, (Object)this);
        }
        return (T)components.iterator().next();
    }

    @Override
    public <T> Set<T> getComponents(Class<T> cls) {
        return Collections.unmodifiableSet(this.componentsByClass.get(cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(IComponent component) throws ComponentIdClashException {
        Map<IToken, IComponent> map = this.componentsByToken;
        synchronized (map) {
            NullCheck.check(component.getComponentId(), "component's id is null (" + component + ")");
            if (this.componentsByToken.get(component.getComponentId()) != null) {
                if (this.componentsByToken.get(component.getComponentId()) == component) {
                    return;
                }
                ComponentIdClashException e = new ComponentIdClashException(component.getComponentId(), (Logger)this.log, this);
                try {
                    this.event(new FatalErrorEvent<LifecycleBus>(this, e));
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw e;
            }
            this.registerComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(IComponent component) {
        Map<IToken, IComponent> map = this.componentsByToken;
        synchronized (map) {
            this.componentsByToken.remove(component.getComponentId());
            Collection<Class> componentClasses = ClassUtils.getSubclasses(component.getClass());
            for (Class cls : componentClasses) {
                this.componentsByClass.get(cls).remove(component);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(component + " of the id " + component.getComponentId().getToken() + " removed from the bus.");
            }
        }
    }

    private void registerComponent(IComponent component) {
        this.componentsByToken.put(component.getComponentId(), component);
        Collection<Class> componentClasses = ClassUtils.getSubclasses(component.getClass());
        for (Class cls : componentClasses) {
            this.componentsByClass.get(cls).add(component);
        }
        this.setComponentState(component.getComponentId(), ComponentState.INSTANTIATED);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(component + " registered under id " + component.getComponentId().getToken());
        }
    }

    @Override
    public IComponent getComponent(IToken name) {
        return this.componentsByToken.get(name);
    }

    @Override
    public void addEventListener(Class<?> event, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(listener, "listener");
        this.eventListeners.get(event).add(listener);
    }

    @Override
    public void addEventListener(Class<?> event, Class<?> component, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(component, "comopnent");
        NullCheck.check(listener, "listener");
        this.componentEventListeners.get(component).get(event).add(listener);
    }

    @Override
    public void addEventListener(Class<?> event, IToken componentName, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(componentName, "componentName");
        NullCheck.check(listener, "listener");
        this.componentNameEventListeners.get(componentName).get(event).add(listener);
    }

    @Override
    public void addEventListener(Class<?> event, IComponent component, IComponentEventListener<?> listener) {
        NullCheck.check(component, "component");
        this.addEventListener(event, component.getComponentId(), listener);
    }

    @Override
    public boolean isListening(Class<?> event, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(listener, "listener");
        if (!this.eventListeners.containsKey(event)) {
            return false;
        }
        return this.eventListeners.get(event).contains(listener);
    }

    @Override
    public boolean isListening(Class<?> event, Class<?> component, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(component, "component");
        NullCheck.check(listener, "listener");
        if (!this.componentEventListeners.containsKey(component)) {
            return false;
        }
        Map<Class, Set<IComponentEventListener>> listeners = this.componentEventListeners.get(component);
        if (!listeners.containsKey(event)) {
            return false;
        }
        return listeners.get(event).contains(listener);
    }

    @Override
    public boolean isListening(Class<?> event, IToken componentId, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(componentId, "componentId");
        NullCheck.check(listener, "listener");
        if (!this.componentNameEventListeners.containsKey(componentId)) {
            return false;
        }
        Map<Class, Set<IComponentEventListener>> listeners = this.componentNameEventListeners.get(componentId);
        if (!listeners.containsKey(event)) {
            return false;
        }
        return listeners.get(event).contains(listener);
    }

    @Override
    public boolean isListening(Class<?> event, IComponent component, IComponentEventListener<?> listener) {
        NullCheck.check(component, "component");
        return this.isListening(event, component.getComponentId(), listener);
    }

    @Override
    public void removeEventListener(Class<?> event, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(listener, "listener");
        if (!this.eventListeners.containsKey(event)) {
            return;
        }
        this.eventListeners.get(event).remove(listener);
    }

    @Override
    public void removeEventListener(Class<?> event, Class<?> component, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(component, "component");
        NullCheck.check(listener, "listener");
        if (!this.componentEventListeners.containsKey(component)) {
            return;
        }
        Map<Class, Set<IComponentEventListener>> listeners = this.componentEventListeners.get(component);
        if (!listeners.containsKey(event)) {
            return;
        }
        listeners.get(event).remove(listener);
    }

    @Override
    public void removeEventListener(Class<?> event, IToken componentId, IComponentEventListener<?> listener) {
        NullCheck.check(event, "event");
        NullCheck.check(componentId, "componentId");
        NullCheck.check(listener, "listener");
        if (!this.componentNameEventListeners.containsKey(componentId)) {
            return;
        }
        Map<Class, Set<IComponentEventListener>> listeners = this.componentNameEventListeners.get(componentId);
        if (!listeners.containsKey(event)) {
            return;
        }
        listeners.get(event).remove(listener);
    }

    @Override
    public void removeEventListener(Class<?> event, IComponent component, IComponentEventListener<?> listener) {
        NullCheck.check(component, "component");
        this.removeEventListener(event, component.getComponentId(), listener);
    }

    private void notifyListenersA(IComponentEvent event) {
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class eventClass : eventClasses) {
            if (!this.eventListeners.containsKey(eventClass)) continue;
            for (IComponentEventListener listener : this.eventListeners.get(eventClass)) {
                if (!this.isRunning()) {
                    return;
                }
                listener.notify(event);
            }
        }
    }

    private void notifyListenersB(IComponentEvent event) {
        Collection<Class> componentClasses = ClassUtils.getSubclasses(event.getSource().getClass());
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class componentClass : componentClasses) {
            if (!this.componentEventListeners.containsKey(componentClass)) continue;
            Map<Class, Set<IComponentEventListener>> listeners = this.componentEventListeners.get(componentClass);
            for (Class eventClass : eventClasses) {
                if (!listeners.containsKey(eventClass)) continue;
                for (IComponentEventListener listener : listeners.get(eventClass)) {
                    if (!this.isRunning()) {
                        return;
                    }
                    listener.notify(event);
                }
            }
        }
    }

    private void notifyListenersC(IComponentEvent event) {
        if (!this.componentNameEventListeners.containsKey(event.getSource().getComponentId())) {
            return;
        }
        Map<Class, Set<IComponentEventListener>> listeners = this.componentNameEventListeners.get(event.getSource().getComponentId());
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class eventClass : eventClasses) {
            if (!listeners.containsKey(eventClass)) continue;
            for (IComponentEventListener listener : listeners.get(eventClass)) {
                if (!this.isRunning()) {
                    return;
                }
                listener.notify(event);
            }
        }
    }

    private void notifyListenersA_Safe(IComponentEvent event) {
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class eventClass : eventClasses) {
            if (!this.eventListeners.containsKey(eventClass)) continue;
            for (IComponentEventListener listener : this.eventListeners.get(eventClass)) {
                try {
                    listener.notify(event);
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.WARNING)) continue;
                    this.log.warning(ExceptionToString.process("Exception happened during notification of event " + event + " on listener " + listener + ".", e));
                }
            }
        }
    }

    private void notifyListenersB_Safe(IComponentEvent event) {
        Collection<Class> componentClasses = ClassUtils.getSubclasses(event.getSource().getClass());
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class componentClass : componentClasses) {
            if (!this.componentEventListeners.containsKey(componentClass)) continue;
            Map<Class, Set<IComponentEventListener>> listeners = this.componentEventListeners.get(componentClass);
            for (Class eventClass : eventClasses) {
                if (!listeners.containsKey(eventClass)) continue;
                for (IComponentEventListener listener : listeners.get(eventClass)) {
                    try {
                        listener.notify(event);
                    }
                    catch (Exception e) {
                        if (!this.log.isLoggable(Level.WARNING)) continue;
                        this.log.warning(ExceptionToString.process("Exception happened during notification of event " + event + " on listener " + listener + ".", e));
                    }
                }
            }
        }
    }

    private void notifyListenersC_Safe(IComponentEvent event) {
        if (!this.componentNameEventListeners.containsKey(event.getSource().getComponentId())) {
            return;
        }
        Map<Class, Set<IComponentEventListener>> listeners = this.componentNameEventListeners.get(event.getSource().getComponentId());
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        for (Class eventClass : eventClasses) {
            if (!listeners.containsKey(eventClass)) continue;
            for (IComponentEventListener listener : listeners.get(eventClass)) {
                try {
                    listener.notify(event);
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.WARNING)) continue;
                    this.log.warning(ExceptionToString.process("Exception happened during notification of event " + event + " on listener " + listener + ".", e));
                }
            }
        }
    }

    private void innerRaiseEvent(IComponentEvent event) {
        if (event instanceof IFatalErrorEvent) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe("Fatal error happenned - component bus is stopping." + Const.NEW_LINE + ((IFatalErrorEvent)event).getSummary());
            }
            this.queue.clear();
            this.running = false;
            this.notifyListenersA_Safe(event);
            this.notifyListenersB_Safe(event);
            this.notifyListenersC_Safe(event);
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Notifying " + event);
        }
        if (!this.isRunning()) {
            return;
        }
        this.notifyListenersA(event);
        if (!this.isRunning()) {
            return;
        }
        this.notifyListenersB(event);
        if (!this.isRunning()) {
            return;
        }
        this.notifyListenersC(event);
    }

    private void innerRaiseEvent_Safe(IComponentEvent event) {
        if (event instanceof IFatalErrorEvent) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe("Fatal error happenned - component bus is stopping." + Const.NEW_LINE + ((IFatalErrorEvent)event).getSummary());
            }
            this.queue.clear();
            this.running = false;
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Notifying (safe) " + event);
        }
        this.notifyListenersA_Safe(event);
        this.notifyListenersB_Safe(event);
        this.notifyListenersC_Safe(event);
    }

    public synchronized boolean event(IComponentEvent event) throws ComponentBusNotRunningException, ComponentBusErrorException, FatalErrorPropagatingEventException {
        NullCheck.check(event, "event");
        if (event instanceof IResetEvent) {
            throw new IllegalArgumentException("you can't broadcast reset event this way, use reset() instead");
        }
        if (!this.isRunning()) {
            if (event instanceof IFatalErrorEvent) {
                try {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Component bus is not running, ignoring fatal error event from " + event.getSource() + ".");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return false;
            }
            throw new ComponentBusNotRunningException(event, (Logger)this.log, this);
        }
        if (event instanceof IFatalErrorEvent) {
            if (!this.isRunning()) {
                try {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Component bus is not running, ignoring fatal error event from " + event.getSource() + ".");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return false;
            }
            this.innerRaiseEvent(event);
            return false;
        }
        if (this.queueProcessing) {
            this.queue.add(event);
            return false;
        }
        if (this.queue.size() > 0) {
            ComponentBusErrorException e = new ComponentBusErrorException("Previous events has not been fully processed! ComponenBus fatal error.", event, (IComponentBus)this);
            this.innerRaiseEvent_Safe(new ComponentBusErrorEvent((IComponentBus)this, (Throwable)e));
            throw e;
        }
        this.queue.add(event);
        this.processQueue();
        return true;
    }

    public synchronized void eventTransactional(IComponentEvent event) throws ComponentBusNotRunningException, ComponentBusErrorException, FatalErrorPropagatingEventException {
        NullCheck.check(event, "event");
        if (event instanceof IResetEvent) {
            throw new IllegalArgumentException("you can't broadcast reset event this way, use reset() instead");
        }
        if (!this.isRunning()) {
            if (event instanceof IFatalErrorEvent) {
                try {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Component bus is not running, ignoring fatal error event from " + event.getSource() + ".");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            throw new ComponentBusNotRunningException(event, (Logger)this.log, this);
        }
        if (!this.queueProcessing) {
            this.event(event);
            return;
        }
        this.innerRaiseEvent(event);
    }

    private void processQueue() throws FatalErrorPropagatingEventException, ComponentBusErrorException {
        boolean dropQueueProcessing = !this.queueProcessing;
        this.queueProcessing = true;
        IComponentEvent event = null;
        while (this.queue.size() != 0) {
            try {
                event = this.queue.poll();
            }
            catch (Exception e) {
                ComponentBusErrorException e1 = new ComponentBusErrorException("Can't poll next event.", (Throwable)e, (IComponentBus)this);
                this.innerRaiseEvent_Safe(new ComponentBusErrorEvent((IComponentBus)this, (Throwable)e));
                throw e1;
            }
            try {
                this.innerRaiseEvent(event);
            }
            catch (FatalErrorPropagatingEventException e1) {
                throw e1;
            }
            catch (ComponentBusErrorException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.innerRaiseEvent_Safe(new FatalErrorPropagatingEvent<LifecycleBus>(this, "Exception happened during the event propagation.", e3, event));
                this.queueProcessing = false;
                throw new FatalErrorPropagatingEventException(event, (Throwable)e3, (IComponentBus)this);
            }
        }
        if (!this.isRunning()) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe("Stopped.");
            }
            if (event != null && !(event instanceof IFatalErrorEvent)) {
                throw new FatalErrorPropagatingEventException(event, this);
            }
        }
        if (dropQueueProcessing) {
            this.queueProcessing = false;
        }
    }

    private void registerComponentStateListeners() {
        this.addEventListener(IStartingEvent.class, this.startingListener);
        this.addEventListener(IStartingPausedEvent.class, this.startingPausedListener);
        this.addEventListener(IStartedEvent.class, this.startedListener);
        this.addEventListener(IStoppingEvent.class, this.stoppingListener);
        this.addEventListener(IStoppedEvent.class, this.stoppedListener);
        this.addEventListener(IPausingEvent.class, this.pausingListener);
        this.addEventListener(IPausedEvent.class, this.pausedListener);
        this.addEventListener(IResumingEvent.class, this.resumingListener);
        this.addEventListener(IResumedEvent.class, this.resumedListener);
    }

    private void setComponentState(IToken componentId, ComponentState newState) {
        this.componentStates.get(componentId).setFlag(newState);
    }

    private void setComponentStates(ComponentState newState) {
        for (Flag<ComponentState> state : this.componentStates.values()) {
            state.setFlag(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IComponent> IComponentController<T> addLifecycleManagement(T component, IComponentControlHelper lifecyleMethods, ComponentDependencies componentDependencies) throws ComponentLifecycleManagementAlreadyRegisteredException {
        Map<IToken, ComponentController> map = this.controls;
        synchronized (map) {
            if (this.controls.containsKey(component.getComponentId())) {
                throw new ComponentLifecycleManagementAlreadyRegisteredException("Lifecycle already registered at " + this + " for component " + component.getComponentId() + ".", (Object)this);
            }
            ComponentController<T> controller = new ComponentController<T>(component, lifecyleMethods, this, this.getLog(), componentDependencies);
            this.controls.put(component.getComponentId(), controller);
            return controller;
        }
    }

    @Override
    public ImmutableFlag<ComponentState> getComponentState(IToken componentId) {
        return this.componentStates.get(componentId).getImmutable();
    }

    @Override
    public ImmutableFlag<ComponentState> getComponentState(Class<? extends IComponent> cls) throws MoreComponentsForClassException {
        IComponent component = this.getComponent(cls);
        if (component == null) {
            return null;
        }
        return this.getComponentState(component.getComponentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleManagement(IComponent component) {
        Map<IToken, ComponentController> map = this.controls;
        synchronized (map) {
            this.controls.remove(component.getComponentId());
        }
    }

    private static class AwaitState
    implements WaitForFlagChange.IAccept<ComponentState> {
        Set<ComponentState> awaiting = new HashSet<ComponentState>();

        public AwaitState(ComponentState ... states) {
            for (ComponentState state : states) {
                this.awaiting.add(state);
            }
        }

        @Override
        public boolean accept(ComponentState flagValue) {
            return this.awaiting.contains((Object)flagValue);
        }
    }
}

