/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AgentModule<AGENT extends IAgent>
implements IComponent {
    private static int moduleNumber = 0;
    private static Object moduleNumberMutex = new Object();
    protected final AGENT agent;
    protected Logger log;
    protected final ComponentController controller;
    protected final IComponentBus eventBus;
    private final Token componentId;
    private IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void startPaused() throws PogamutException {
            AgentModule.this.start(true);
        }

        @Override
        public void start() throws PogamutException {
            AgentModule.this.start(false);
        }

        @Override
        public void stop() throws PogamutException {
            AgentModule.this.stop();
        }

        @Override
        public void kill() {
            AgentModule.this.kill();
        }

        @Override
        public void reset() {
            AgentModule.this.reset();
        }

        @Override
        public void pause() {
            AgentModule.this.pause();
        }

        @Override
        public void resume() {
            AgentModule.this.resume();
        }
    };

    public AgentModule(AGENT agent) {
        this(agent, null);
    }

    public AgentModule(AGENT agent, Logger log) {
        this(agent, log, null);
    }

    public AgentModule(AGENT agent, Logger log, ComponentDependencies dependencies) {
        this.agent = agent;
        NullCheck.check(agent, "agent");
        this.componentId = this.initComponentId();
        NullCheck.check(this.componentId, "componentId initialization");
        this.log = log == null ? agent.getLogger().getCategory(this) : log;
        this.eventBus = agent.getEventBus();
        if (dependencies == null) {
            dependencies = new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent);
        }
        this.controller = new ComponentController<AgentModule>(this, this.control, this.eventBus, this.log, dependencies);
        this.eventBus.register(this);
    }

    public Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Token initComponentId() {
        Object object = moduleNumberMutex;
        synchronized (object) {
            return Tokens.get(this.getClass().getSimpleName() + moduleNumber++);
        }
    }

    @Override
    public Token getComponentId() {
        return this.componentId;
    }

    public boolean isRunning() {
        return this.controller.isRunning();
    }

    public ImmutableFlag<ComponentState> getState() {
        return this.controller.getState();
    }

    public String toString() {
        if (this == null) {
            return "AgentModule-instantiating";
        }
        return this.getClass().getSimpleName();
    }

    protected void start(boolean startToPaused) {
    }

    protected void stop() {
        this.cleanUp();
    }

    protected void kill() {
        this.cleanUp();
    }

    protected void pause() {
    }

    protected void resume() {
    }

    protected void reset() {
        this.cleanUp();
    }

    protected void cleanUp() {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Cleaning up!");
        }
    }
}

