/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SocialSteeringsBeta.RefLocation;
import SteeringProperties.SteeringProperties;
import SteeringProperties.WallFollowingProperties;
import SteeringStuff.IRaysFlagChanged;
import SteeringStuff.ISteering;
import SteeringStuff.RaycastingManager;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringRay;
import SteeringStuff.SteeringTools;
import SteeringStuff.SteeringType;
import Steerings.ObstacleAvoidanceSteer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

public class WallFollowingSteer
implements ISteering,
IRaysFlagChanged {
    private UT2004Bot botself;
    private RaycastingManager rayManager;
    private int wallForce;
    private int orderOfTheForce;
    private double attractiveForceWeight;
    private double repulsiveForceWeight;
    private double convexEdgesForceWeight;
    private double concaveEdgesForceWeight;
    private boolean justMySide;
    private boolean specialDetection;
    private boolean frontCollisions;
    int DISTANCE_FROM_THE_WALL = 166;
    private static final int DEFAULTCOUNTER = 10;
    private boolean goFast = false;
    State state;
    int counter;
    boolean convexTurning;
    private boolean raysReady;
    private HashMap<String, Future<AutoTraceRay>> myFutureRays;
    protected static final String NLEFTFRONT = "wleftfront";
    protected static final String NLEFT = "wleft";
    protected static final String NRIGHTFRONT = "wrightfront";
    protected static final String NRIGHT = "wright";
    protected static final String NFRONT = "wfront";
    Random random = new Random();
    AutoTraceRay nleft;
    AutoTraceRay nright;
    AutoTraceRay nleftfront;
    AutoTraceRay nrightfront;
    AutoTraceRay nfront;
    int shortSideRayLength;
    int shortSideFrontRayLength;
    int longSideRayLength;
    int longSideFrontRayLength;
    int shortFrontRayLength;
    int longFrontRayLength;

    public WallFollowingSteer(UT2004Bot bot, RaycastingManager rayManager, SteeringProperties newProperties) {
        this.botself = bot;
        this.rayManager = rayManager;
        this.setProperties(newProperties);
        this.state = State.NOTHING;
        this.counter = 0;
        this.convexTurning = false;
        this.prepareRays();
    }

    public WallFollowingSteer(UT2004Bot bot, RaycastingManager rayManager) {
        this.botself = bot;
        this.rayManager = rayManager;
        this.setProperties(new WallFollowingProperties());
        this.state = State.NOTHING;
        this.counter = 0;
        this.convexTurning = false;
        this.prepareRays();
    }

    private void prepareRays() {
        int shortLength = 8;
        int longLength = 12;
        this.shortSideRayLength = (int)(25.0 * (double)shortLength * (double)this.DISTANCE_FROM_THE_WALL / 166.0);
        this.longSideRayLength = (int)(25.0 * (double)longLength * (double)this.DISTANCE_FROM_THE_WALL / 166.0);
        this.shortSideFrontRayLength = (int)(25.0 * (double)shortLength * 2.0 * (double)this.DISTANCE_FROM_THE_WALL / 166.0);
        this.longSideFrontRayLength = (int)(25.0 * (double)longLength * 2.0 * (double)this.DISTANCE_FROM_THE_WALL / 166.0);
        this.shortFrontRayLength = (int)(25.0 * (double)shortLength * Math.sqrt(3.0) * (double)this.DISTANCE_FROM_THE_WALL / 166.0);
        this.longFrontRayLength = (int)(25.0 * (double)longLength * Math.sqrt(3.0) * (double)this.DISTANCE_FROM_THE_WALL / 166.0);
        LinkedList<SteeringRay> rayList = new LinkedList<SteeringRay>();
        rayList.add(new SteeringRay(NLEFT, new Vector3d(0.0, -1.0, 0.0), this.longSideRayLength));
        rayList.add(new SteeringRay(NLEFTFRONT, new Vector3d(Math.sqrt(3.0), -1.0, 0.0), this.longSideFrontRayLength));
        rayList.add(new SteeringRay(NRIGHTFRONT, new Vector3d(Math.sqrt(3.0), 1.0, 0.0), this.longSideFrontRayLength));
        rayList.add(new SteeringRay(NRIGHT, new Vector3d(0.0, 1.0, 0.0), this.longSideRayLength));
        rayList.add(new SteeringRay(NFRONT, new Vector3d(1.0, 0.0, 0.0), this.longFrontRayLength));
        this.rayManager.addRays(SteeringType.WALL_FOLLOWING, rayList, this);
        this.raysReady = false;
    }

    @Override
    public void flagRaysChanged() {
        this.myFutureRays = this.rayManager.getMyFutureRays(SteeringType.WALL_FOLLOWING);
        this.raysReady = false;
        this.listenToRays();
    }

    private void listenToRays() {
        for (String rayId : this.myFutureRays.keySet()) {
            Future<AutoTraceRay> fr = this.myFutureRays.get(rayId);
            if (!fr.isDone()) continue;
            try {
                if (rayId.equals(NLEFTFRONT)) {
                    this.nleftfront = fr.get();
                } else if (rayId.equals(NRIGHTFRONT)) {
                    this.nrightfront = fr.get();
                } else if (rayId.equals(NLEFT)) {
                    this.nleft = fr.get();
                } else if (rayId.equals(NRIGHT)) {
                    this.nright = fr.get();
                } else if (rayId.equals(NFRONT)) {
                    this.nfront = fr.get();
                }
                this.raysReady = true;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ObstacleAvoidanceSteer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(ObstacleAvoidanceSteer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, RefLocation focus) {
        double multiplier;
        Vector3d normal;
        Vector3d botToHitLocation;
        wantsToGoFaster.setValue(false);
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (!this.raysReady) {
            this.listenToRays();
            return nextVelocity;
        }
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        boolean shortrays = false;
        boolean sensornLeft = false;
        boolean sensornRight = false;
        boolean sensornLeftFront = false;
        boolean sensornRightFront = false;
        boolean sensornFront = false;
        if (this.nleftfront != null) {
            sensornLeftFront = this.nleftfront.isResult();
        }
        if (this.nrightfront != null) {
            sensornRightFront = this.nrightfront.isResult();
        }
        if (this.nleft != null) {
            sensornLeft = this.nleft.isResult();
        }
        if (this.nright != null) {
            sensornRight = this.nright.isResult();
        }
        if (this.nfront != null) {
            sensornFront = this.nfront.isResult();
        }
        if (this.state == State.NOTHING) {
            if (sensornLeft && sensornLeftFront) {
                this.state = State.LEFT;
                this.counter = 10;
            } else if (sensornRight && sensornRightFront) {
                this.state = State.RIGHT;
                this.counter = 10;
            } else if (sensornFront && this.frontCollisions) {
                botToHitLocation = new Vector3d(this.nfront.getHitLocation().x - this.botself.getLocation().x, this.nfront.getHitLocation().y - this.botself.getLocation().y, 0.0);
                normal = this.nfront.getHitNormal();
                if (Math.PI - normal.angle(actualVelocity) < 0.6283185307179586) {
                    boolean turnLeft = normal.angle(actualVelocity) == 180.0 ? this.random.nextBoolean() : SteeringTools.pointIsLeftFromTheVector(actualVelocity, normal);
                    Vector3d turn = SteeringTools.getTurningVector(actualVelocity, turnLeft);
                    turn.normalize();
                    turn.scale(0.5);
                    normal.add(turn);
                    normal.normalize();
                    double multiplier2 = Math.pow(((double)this.longFrontRayLength - botToHitLocation.length()) * 2.0 / (double)this.longFrontRayLength, this.orderOfTheForce);
                    normal.scale(multiplier2 * (double)this.wallForce);
                    nextVelocity.add(normal);
                    return nextVelocity;
                }
            }
        } else if (this.state == State.LEFT) {
            if (sensornLeft && sensornLeftFront) {
                this.counter = 10;
            }
        } else if (this.state == State.RIGHT && sensornRight && sensornRightFront) {
            this.counter = 10;
        }
        if (this.justMySide) {
            if (this.state.equals((Object)State.LEFT)) {
                sensornRight = false;
                sensornRightFront = false;
            } else if (this.state.equals((Object)State.RIGHT)) {
                sensornLeft = false;
                sensornLeftFront = false;
            }
        }
        if (this.goFast) {
            if (sensornFront) {
                wantsToGoFaster.setValue(false);
            } else {
                wantsToGoFaster.setValue(true);
            }
        } else if (!shortrays) {
            wantsToGoFaster.setValue(true);
        } else {
            wantsToGoFaster.setValue(false);
        }
        if (sensornLeft) {
            botToHitLocation = new Vector3d(this.nleft.getHitLocation().x - this.botself.getLocation().x, this.nleft.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.nleft.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longSideRayLength - botToHitLocation.length()) / (double)this.longSideRayLength, this.orderOfTheForce);
            normal.scale(this.attractiveForceWeight * multiplier * (double)this.wallForce);
            nextVelocity.sub(normal);
            if (botToHitLocation.length() < (double)this.shortSideRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortSideRayLength - botToHitLocation.length()) * 2.0 / (double)this.shortSideRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(this.repulsiveForceWeight * multiplier * (double)this.wallForce);
                nextVelocity.add(normal);
            }
        }
        if (sensornRight) {
            botToHitLocation = new Vector3d(this.nright.getHitLocation().x - this.botself.getLocation().x, this.nright.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.nright.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longSideRayLength - botToHitLocation.length()) / (double)this.longSideRayLength, this.orderOfTheForce);
            normal.scale(this.attractiveForceWeight * multiplier * (double)this.wallForce);
            nextVelocity.sub(normal);
            if (botToHitLocation.length() < (double)this.shortSideRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortSideRayLength - botToHitLocation.length()) * 2.0 / (double)this.shortSideRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(this.repulsiveForceWeight * multiplier * (double)this.wallForce);
                nextVelocity.add(normal);
            }
        }
        if (sensornLeftFront) {
            botToHitLocation = new Vector3d(this.nleftfront.getHitLocation().x - this.botself.getLocation().x, this.nleftfront.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.nleftfront.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longSideFrontRayLength - botToHitLocation.length()) / (double)this.longSideFrontRayLength, this.orderOfTheForce);
            normal.scale(this.attractiveForceWeight * multiplier * (double)this.wallForce);
            nextVelocity.sub(normal);
            if (botToHitLocation.length() < (double)this.shortSideFrontRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortSideFrontRayLength - botToHitLocation.length()) * 2.0 / (double)this.shortSideFrontRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(this.repulsiveForceWeight * multiplier * (double)this.wallForce);
                nextVelocity.add(normal);
            }
        }
        if (sensornRightFront) {
            botToHitLocation = new Vector3d(this.nrightfront.getHitLocation().x - this.botself.getLocation().x, this.nrightfront.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.nrightfront.getHitNormal();
            multiplier = Math.pow(1.0 - ((double)this.longSideFrontRayLength - botToHitLocation.length()) / (double)this.longSideFrontRayLength, this.orderOfTheForce);
            normal.scale(this.attractiveForceWeight * multiplier * (double)this.wallForce);
            nextVelocity.sub(normal);
            if (botToHitLocation.length() < (double)this.shortSideFrontRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortSideFrontRayLength - botToHitLocation.length()) * 2.0 / (double)this.shortSideFrontRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(this.repulsiveForceWeight * multiplier * (double)this.wallForce);
                nextVelocity.add(normal);
            }
        }
        if (sensornFront) {
            botToHitLocation = new Vector3d(this.nfront.getHitLocation().x - this.botself.getLocation().x, this.nfront.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.nfront.getHitNormal();
            if (botToHitLocation.length() < (double)this.shortFrontRayLength) {
                shortrays = true;
                multiplier = Math.pow(((double)this.shortFrontRayLength - botToHitLocation.length()) * 2.0 / (double)this.shortFrontRayLength, this.orderOfTheForce);
                normal.normalize();
                normal.scale(this.repulsiveForceWeight * 3.0 * multiplier * (double)this.wallForce);
                nextVelocity.add(normal);
            }
        }
        boolean nextTurning = false;
        if (this.specialDetection) {
            if (this.state.equals((Object)State.LEFT)) {
                if (sensornFront && (this.convexTurning || Math.abs(this.nfront.getHitNormal().angle(actualVelocity) - Math.PI) < 0.7853981633974483) || sensornLeftFront && Math.abs(this.nleftfront.getHitNormal().angle(actualVelocity) - Math.PI) < 1.5707963267948966 && this.convexTurning || sensornLeftFront && Math.abs(this.nleftfront.getHitNormal().angle(actualVelocity) - Math.PI) < 0.7853981633974483 || sensornLeft && Math.abs(this.nleft.getHitNormal().angle(actualVelocity) - Math.PI) < 1.5707963267948966 && this.convexTurning) {
                    nextTurning = true;
                    double k = 1.0;
                    k = sensornFront ? this.nfront.getHitNormal().angle(actualVelocity) / Math.PI : (sensornLeftFront ? 0.6 * this.nleftfront.getHitNormal().angle(actualVelocity) / Math.PI : 0.3 * this.nleft.getHitNormal().angle(actualVelocity) / Math.PI);
                    Vector3d turningVector = SteeringTools.getTurningVector2(actualVelocity, false);
                    turningVector.scale(k * this.convexEdgesForceWeight);
                    this.counter = 10;
                    this.convexTurning = nextTurning;
                    return turningVector;
                }
            } else if (this.state.equals((Object)State.RIGHT) && (sensornFront && (this.convexTurning || Math.abs(this.nfront.getHitNormal().angle(actualVelocity) - Math.PI) < 0.7853981633974483) || sensornRightFront && Math.abs(this.nrightfront.getHitNormal().angle(actualVelocity) - Math.PI) < 1.5707963267948966 && this.convexTurning || sensornRightFront && Math.abs(this.nrightfront.getHitNormal().angle(actualVelocity) - Math.PI) < 0.7853981633974483 || sensornRight && Math.abs(this.nright.getHitNormal().angle(actualVelocity) - Math.PI) < 1.5707963267948966 && this.convexTurning)) {
                nextTurning = true;
                double k = 1.0;
                k = sensornFront ? this.nfront.getHitNormal().angle(actualVelocity) / Math.PI : (sensornRightFront ? 0.6 * this.nrightfront.getHitNormal().angle(actualVelocity) / Math.PI : 0.3 * this.nright.getHitNormal().angle(actualVelocity) / Math.PI);
                Vector3d turningVector = SteeringTools.getTurningVector2(actualVelocity, true);
                turningVector.scale(k * this.convexEdgesForceWeight);
                this.counter = 10;
                this.convexTurning = nextTurning;
                return turningVector;
            }
        } else if (this.state == State.LEFT) {
            if (sensornLeftFront && sensornFront) {
                Vector3d turningVector = SteeringTools.getTurningVector2(actualVelocity, false);
                turningVector.scale(this.convexEdgesForceWeight * 0.8);
                return turningVector;
            }
        } else if (this.state == State.RIGHT && sensornRightFront && sensornFront) {
            Vector3d turningVector = SteeringTools.getTurningVector2(actualVelocity, true);
            turningVector.scale(this.convexEdgesForceWeight * 0.8);
            return turningVector;
        }
        if (this.state == State.LEFT) {
            if (!sensornLeft && !sensornLeftFront) {
                if (this.counter > 0) {
                    --this.counter;
                    Vector3d turningVector = SteeringTools.getTurningVector2(actualVelocity, true);
                    if (this.convexTurning) {
                        turningVector.scale(0.5);
                    }
                    turningVector.scale(this.concaveEdgesForceWeight * 0.8);
                    return turningVector;
                }
                this.state = State.NOTHING;
            }
        } else if (this.state == State.RIGHT && !sensornRight && !sensornRightFront) {
            if (this.counter > 0) {
                --this.counter;
                Vector3d turningVector = SteeringTools.getTurningVector2(actualVelocity, false);
                if (this.convexTurning) {
                    turningVector.scale(0.5);
                }
                turningVector.scale(this.concaveEdgesForceWeight * 0.8);
                return turningVector;
            }
            this.state = State.NOTHING;
        }
        this.convexTurning = nextTurning;
        return nextVelocity;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.wallForce = ((WallFollowingProperties)newProperties).getWallForce();
        this.orderOfTheForce = ((WallFollowingProperties)newProperties).getOrderOfTheForce();
        this.attractiveForceWeight = ((WallFollowingProperties)newProperties).getAttractiveForceWeight();
        this.repulsiveForceWeight = ((WallFollowingProperties)newProperties).getRepulsiveForceWeight();
        this.concaveEdgesForceWeight = ((WallFollowingProperties)newProperties).getConcaveEdgesForceWeight();
        this.convexEdgesForceWeight = ((WallFollowingProperties)newProperties).getConvexEdgesForceWeight();
        this.justMySide = ((WallFollowingProperties)newProperties).isJustMySide();
        this.specialDetection = ((WallFollowingProperties)newProperties).isSpecialDetection();
        this.frontCollisions = ((WallFollowingProperties)newProperties).isFrontCollisions();
    }

    public WallFollowingProperties getProperties() {
        WallFollowingProperties properties = new WallFollowingProperties();
        properties.setWallForce(this.wallForce);
        properties.setOrderOfTheForce(this.orderOfTheForce);
        properties.setAttractiveForceWeight(this.attractiveForceWeight);
        properties.setRepulsiveForceWeight(this.repulsiveForceWeight);
        properties.setConcaveEdgesForceWeight(this.concaveEdgesForceWeight);
        properties.setConvexEdgesForceWeight(this.convexEdgesForceWeight);
        properties.setJustMySide(this.justMySide);
        properties.setSpecialDetection(this.specialDetection);
        properties.setFrontCollisions(this.frontCollisions);
        return properties;
    }

    static enum State {
        NOTHING,
        LEFT,
        RIGHT;

    }
}

