/**
 * Emohawk Bot, an implementation of the environment interface standard that 
 * facilitates the connection between GOAL and Emohawk. 
 * 
 * Copyright (C) 2012 Emohawk Bot authors.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package nl.tudelft.goal.emohawk.translators;

import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Java2Parameter;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import eis.iilang.Identifier;
import eis.iilang.Numeral;
import eis.iilang.Parameter;

public class GameTranslator implements Java2Parameter<Game> {

	@Override
	public Parameter[] translate(Game o) throws TranslationException {

		// gameinfo(<Gametype>, <Map>, <GoalScore>, <timeLimit>)
		return new Parameter[] { new Identifier(o.getGameType().name()), new Identifier(o.getMapName()),
				new Identifier(o.getMapName()), new Numeral(o.getTeamScoreLimit()), new Numeral(o.getRemainingTime()) };
	}

	@Override
	public Class<? extends Game> translatesFrom() {
		return Game.class;
	}

}