/**
 * Emohawk Bot, an implementation of the environment interface standard that 
 * facilitates the connection between GOAL and Emohawk. 
 * 
 * Copyright (C) 2012 Emohawk Bot authors.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package nl.tudelft.goal.emohawk.translators;

import java.util.Arrays;

import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Java2Parameter;
import nl.tudelft.goal.EIS2Java.translation.Parameter2Java;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import eis.iilang.Identifier;
import eis.iilang.Parameter;

public class AnimTypeTranslator implements Java2Parameter<AnimType>, Parameter2Java<AnimType> {

	@Override
	public AnimType translate(Parameter parameter) throws TranslationException {
		String animTypeString = Translator.getInstance().translate2Java(parameter, String.class);

		try {
			return AnimType.valueOf(animTypeString);
		} catch (IllegalArgumentException e) {
			String message = String.format("%s was not a skin. Expected one of %s.", animTypeString,
					Arrays.toString(EmoticonType.values()));
			throw new TranslationException(message, e);
		}
	}

	@Override
	public Class<AnimType> translatesTo() {
		return AnimType.class;
	}

	@Override
	public Parameter[] translate(AnimType argument) throws TranslationException {
		return new Parameter[] { new Identifier(argument.name()) };
	}

	@Override
	public Class<? extends AnimType> translatesFrom() {
		return AnimType.class;
	}

}