/**
 * Emohawk Bot, an implementation of the environment interface standard that 
 * facilitates the connection between GOAL and Emohawk. 
 * 
 * Copyright (C) 2012 Emohawk Bot authors.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */

package nl.tudelft.goal.emohawk.translators;

import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Java2Parameter;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import nl.tudelft.goal.unreal.translators.LocationTranslator;
import nl.tudelft.goal.unreal.translators.RotationTranslator;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import eis.iilang.Function;
import eis.iilang.Identifier;
import eis.iilang.Parameter;

public class AgentInfoTranslator implements Java2Parameter<AgentInfo> {

	@Override
	public Parameter[] translate(AgentInfo o) throws TranslationException {
		EmoticonType emoteLeft = EmoticonType.get(o.getSelf().getEmotLeft());
		EmoticonType emoteCenter = EmoticonType.get(o.getSelf().getEmotCenter());
		EmoticonType emoteRight = EmoticonType.get(o.getSelf().getEmotRight());
		
		return new Parameter[] {
				new Identifier(o.getSelf().getId().getStringId()), 
				new Identifier(o.getName()),
				Translator.getInstance().translate2Parameter(o.getLocation())[0],
				Translator.getInstance().translate2Parameter(o.getRotation())[0],
				Translator.getInstance().translate2Parameter(emoteLeft)[0], 
				Translator.getInstance().translate2Parameter(emoteCenter)[0], 
				Translator.getInstance().translate2Parameter(emoteRight)[0]};
	}

	@Override
	public Class<? extends AgentInfo> translatesFrom() {
		return AgentInfo.class;
	}

}