/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

public class ADExecutor
extends AbstractExecutor
implements ElementExecutor {
    private Adopt adapt;
    private PoshPlan plan;
    private SenseListExecutor<Adopt> exitConditionExecutor;

    protected ADExecutor(PoshPlan plan, Adopt ad, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.plan = plan;
        this.adapt = ad;
        this.exitConditionExecutor = new SenseListExecutor<Adopt>(ad.getExitCondition(), ctx, log);
    }

    public boolean isExit(IWorkExecutor workExecutor) {
        return this.exitConditionExecutor.fire(workExecutor, true).wasSuccess();
    }

    public Trigger<Adopt> getExitCondition() {
        return this.adapt.getExitCondition();
    }

    public TriggeredAction getAdoptedElement() {
        return this.adapt.getAdoptedElement();
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (this.isExit(workExecuter)) {
            return new FireResult(FireResult.Type.SURFACE);
        }
        return new FireResult(FireResult.Type.FOLLOW, this.newTriggeredAction());
    }

    private StackElement newTriggeredAction() {
        return this.getElement(this.plan, this.getAdoptedElement().getActionCall(), FireResult.Type.SURFACE, FireResult.Type.SURFACE, FireResult.Type.SURFACE, FireResult.Type.FAILED);
    }

    @Override
    public TriggerResult getTriggerResult() {
        return new TriggerResult(true);
    }
}

